package com.liquidnet.service.stone.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoSimpleVo;
import com.liquidnet.service.base.ResponseDto;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

/**
 * 内部接口调用工具类
 */
@Component
public class InnerUtils {
    @Value("${liquidnet.service.adam.url}")
    private String adamUrl;

    public AdamUserInfoSimpleVo getUserInfo() throws Exception {
        MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
        header.add("Accept", "application/json;charset=UTF-8");
        header.add("Authorization", "Bearer " + CurrentUtil.getToken());
        String resultData = HttpUtil.post(adamUrl + "/adam/user/gif/mobile", null, header);
        ResponseDto<AdamUserInfoSimpleVo> innerReturnVo = JsonUtils.fromJson(resultData, new TypeReference<ResponseDto<AdamUserInfoSimpleVo>>() {
        });
        return innerReturnVo.getData();
    }
}
