package com.liquidnet.client.admin.zhengzai.sweet.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityDrawVo;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

import java.util.LinkedList;
import java.util.List;

@Component
public class SweetRedisAdminUtils {

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private RedisUtil redisUtil;

    public void setIntegralActivityList(List<IntegralActivityVo> voList) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_LIST;
        boolean set = redisUtil.set(redisKey, voList);
    }

    public void setIntegralActivityInfo(IntegralActivityVo integralActivityVo) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_INFO.concat(integralActivityVo.getIntegralActivityId());
        boolean set = redisUtil.set(redisKey, integralActivityVo);
    }

    public void incrIntegralActivityPrizeNum(String integralActivityId, String prizeId, Integer num) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_NUM
                .concat(integralActivityId)
                .concat(":prizeId:")
                .concat(prizeId);
        redisUtil.incr(redisKey, num);
    }

    public void incrIntegralActivityPrizeWinnersNum(String integralActivityId, String prizeId, Integer num) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_WINNERS_NUM
                .concat(integralActivityId)
                .concat(":prizeId:")
                .concat(prizeId);
        redisUtil.incr(redisKey, num);
    }

    public void decrIntegralActivityPrizeNum(String integralActivityId, String prizeId, Integer num) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_NUM
                .concat(integralActivityId)
                .concat(":prizeId:")
                .concat(prizeId);
        redisUtil.decr(redisKey, num);
    }

    public void decrIntegralActivityPrizeWinnersNum(String integralActivityId, String prizeId, Integer num) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_WINNERS_NUM
                .concat(integralActivityId)
                .concat(":prizeId:")
                .concat(prizeId);
        redisUtil.decr(redisKey, num);
    }

    public void setIntegralActivityDraw(LinkedList<IntegralActivityDrawVo> sweetIntegralActivityDraws, String integralActivityId, String userId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_IN_USER
                .concat(integralActivityId)
                .concat(":userId:")
                .concat(userId);
        redisUtil.set(redisKey, sweetIntegralActivityDraws);
    }

    public void setIntegralActivityDrawInfo(String drawId) {
        String redisKeyDraw = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_DRAW_INFO
                .concat(drawId);
        IntegralActivityDrawVo info = (IntegralActivityDrawVo) redisUtil.get(redisKeyDraw);
        info.setReceivingStatus(2);
        redisUtil.set(redisKeyDraw, info);
    }
}
