package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 巡演
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinOrderCoupons implements Serializable ,Cloneable {

    private static final long serialVersionUID = 231L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * order_id
     */
    private String orderId;

    /**
     * 券code = 券id
     */
    private String couponCode;

    /**
     * 券类型[1-代金券｜2-满减券｜3-兑换券｜4-折扣券 | 101-优先券]
     */
    private Integer couponType;

    /**
     * 券的优惠金额
     */
    private BigDecimal couponPrice;

    /**
     * comment
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    private static final KylinOrderCoupons obj = new KylinOrderCoupons();
    public static KylinOrderCoupons getNew() {
        try {
            return (KylinOrderCoupons) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinOrderCoupons();
        }
    }
}
