package com.liquidnet.client.admin.web.controller.zhengzai.smile;


import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileShowService;
import com.liquidnet.service.smile.entity.SmileShow;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-15
 */
@RestController
@RequestMapping("/smile/show")
public class SmileShowController {

    @Autowired
    ISmileShowService smileShowService;

    @GetMapping("/list")
    @ApiOperation("获得演出列表")
    @ResponseBody
    public AjaxResult showList(@RequestParam(name = "name", required = false) String name,@RequestParam(name = "city", required = false) String city){
        List<SmileShow> showList = smileShowService.showList(name,city);
        return AjaxResult.success(showList);
    }

    @PostMapping("create")
    @ApiOperation("新建票提")
    @ResponseBody
    public AjaxResult create(@RequestBody List<SmileShow> showList){
        if (smileShowService.create(showList)){
            return AjaxResult.success();
        }
        return AjaxResult.error();
    }
}
