package com.liquidnet.client.admin.zhengzai.smile.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.common.utils.bean.BeanUtils;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileOrganizationService;
import com.liquidnet.client.admin.zhengzai.smile.vo.SmileOrganizationVo;
import com.liquidnet.service.smile.entity.SmileOrganization;
import com.liquidnet.service.smile.mapper.SmileOrganizationMapper;
import com.liquidnet.service.smile.mapper.SmileUserMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-14
 */
@Slf4j
@Service
public class SmileOrganizationServiceImpl extends ServiceImpl<SmileOrganizationMapper, SmileOrganization> implements ISmileOrganizationService {

    @Autowired
    SmileOrganizationMapper smileOrganizationMapper;

    @Autowired
    SmileUserMapper smileUserMapper;

    @Override
    public List<SmileOrganizationVo> organizationList() {
        LambdaQueryWrapper<SmileOrganization> queryWrapper = Wrappers.lambdaQuery(SmileOrganization.class);
        queryWrapper.eq(SmileOrganization::getDelTag,0);
        List<SmileOrganization> smileOrganizations = smileOrganizationMapper.selectList(queryWrapper);
        return smileOrganizations.stream().map(smileOrganization -> {
            SmileOrganizationVo smileOrganizationVo = new SmileOrganizationVo();
            BeanUtils.copyBeanProp(smileOrganization,smileOrganizationVo);
            log.info("organizationList orgId:{}", smileOrganization.getId());
            //关联查询人数
            smileOrganizationVo.setProper(smileUserMapper.strip(smileOrganization.getId()));
            return smileOrganizationVo;
        }).collect(Collectors.toList());
    }

    @Override
    public Integer create(SmileOrganization smileOrganization) {
        log.info("smileOrganization:{}",smileOrganization);
        smileOrganization.setCreatedDate(LocalDateTime.now());
        smileOrganization.setUpdatedDate(LocalDateTime.now());
        smileOrganization.setDelTag(0);
        return smileOrganizationMapper.insert(smileOrganization);
    }

    @Override
    public Boolean update(SmileOrganization smileOrganization) {
        smileOrganization.setUpdatedDate(LocalDateTime.now());
        smileOrganizationMapper.updateById(smileOrganization);
        return true;
    }


}
