package com.liquidnet.client.admin.zhengzai.smile.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileSchoolService;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.service.smile.entity.SmileSchool;
import com.liquidnet.service.smile.mapper.SmileSchoolMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-14
 */
@Slf4j
@Service
public class SmileSchoolServiceImpl extends ServiceImpl<SmileSchoolMapper, SmileSchool> implements ISmileSchoolService {

    @Autowired
    SmileSchoolMapper smileSchoolMapper;

    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    @Override
    public List<SmileSchool> schoolList(String name) {
        LambdaQueryWrapper<SmileSchool> queryWrapper = Wrappers.lambdaQuery(SmileSchool.class);
        if (StringUtils.isNotBlank(name)) {
            log.info("smileSchool:name{}", name);
            queryWrapper.like(SmileSchool::getName, name);
        }
        return smileSchoolMapper.selectList(queryWrapper);
    }

    @Override
    public SmileSchool getSchoolById(Long id) {
        return smileSchoolMapper.selectById(id);
    }

    @Override
    public Boolean create(SmileSchool smileSchool) {
        log.info("smileSchool:{}", smileSchool);
        LambdaQueryWrapper<SmileSchool> queryWrapper = Wrappers.lambdaQuery(SmileSchool.class);
        queryWrapper.eq(SmileSchool::getName, smileSchool.getName());
        if (smileSchoolMapper.selectOne(queryWrapper) == null) {
            int id = smileSchoolMapper.insert(smileSchool);
            if (id > 0) {
                //更新redis
                log.info("school, id:{},smileSchool:{}", smileSchool.getId(), smileSchool);
//                redisDataSourceUtil.getRedisSmileUtil().set(SmileRedisConst.SMILE_SCHOOL + id, smileSchool);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateSchoolById(SmileSchool smileSchool) {
        LambdaQueryWrapper<SmileSchool> queryWrapper = Wrappers.lambdaQuery(SmileSchool.class);
        queryWrapper.eq(SmileSchool::getId, smileSchool.getId());
        if (smileSchoolMapper.update(smileSchool, queryWrapper) > 0) {
            //更新redis
            log.info("school, id:{},smileSchool:{}", smileSchool.getId(), smileSchool);
            return true;
        }
        return false;
    }


}
