package com.liquidnet.service.adam.constant;

public class AdamUserConst {

    public enum UserAuthTypeEnum {
        EMAIL,
        SMS_CODE
    }

    public enum UserAuthResultEnum {
        SUCCESS,
        FAILURE,
        PENDING
    }

    public enum UserRoleEnum {
        Administrator, Executor, Viewer;
    }

    public enum Logical {
        AND, OR;
    }

    public enum UserStatusEnum{
            REMOVED("0","Removed"),
            ACTIVE("1","Active"),
            INVITED("2","Invited");
        private String code;

        private String desc;

        UserStatusEnum(String code,String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static UserStatusEnum byCode(String code) {
            UserStatusEnum[] values = UserStatusEnum.values();
            for (UserStatusEnum v : values) {
                if (v.code.equals(code)) {
                    return v;
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }
    }
}
