package com.liquidnet.service.adam.dto.vo;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.SensitizeUtil;
import com.liquidnet.service.adam.entity.AdamEnters;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "AdamEntersVo", description = "入场人")
@Data
public class AdamEntersVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -9143065766410946012L;
    @ApiModelProperty(position = 10, value = "入场人ID[64]")
    private String entersId;
    @ApiModelProperty(position = 11, value = "用户ID[50]")
    private String uid;
    @ApiModelProperty(position = 12, value = "证件类型:1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证")
    private Integer type;
    @ApiModelProperty(position = 13, value = "姓名[50]")
    private String name;
    @ApiModelProperty(position = 14, value = "手机号[11]")
    private String mobile;
    @ApiModelProperty(position = 15, value = "证件号[11]")
    private String idCard;
    @ApiModelProperty(position = 16, value = "默认:0-否,1-是")
    private Boolean isDefault;
    @ApiModelProperty(position = 17, value = "状态:0-INIT,1-NORMAL,2-INVALID")
    private Integer state;
    private String createdAt;
    private String updatedAt;
    private String deletedAt;

    private static final AdamEntersVo obj = new AdamEntersVo();

    public static AdamEntersVo getNew() {
        try {
            return (AdamEntersVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamEntersVo();
    }

    public AdamEntersVo copy(AdamEnters source) {
        if (null == source) return this;
        this.setEntersId(source.getEntersId());
        this.setUid(source.getUid());
        this.setType(source.getType());
        this.setName(SensitizeUtil.chineseName(source.getName()));
        this.setMobile(SensitizeUtil.custom(source.getMobile(), 3, 4));
        this.setIdCard(SensitizeUtil.custom(source.getIdCard(), 3, 2));
        this.setIsDefault(source.getIsDefault());
        this.setState(source.getState());
        this.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(source.getCreatedAt()));
        this.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(source.getUpdatedAt()));
        this.setDeletedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(source.getDeletedAt()));
        return this;
    }
}
