package com.liquidnet.service.consumer.service.processor;

import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.consumer.service.IBaseDao;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;
import org.springframework.amqp.core.Message;

import javax.annotation.Resource;

/**
 * ConsumerProcessor.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2021/4/29
 */
@Slf4j
@Component
public class ConsumerProcessor {
    @Resource
    IBaseDao baseDao;

//    @RabbitListener(bindings = @QueueBinding(
//            exchange = @Exchange("queue.sql"),
//            key = "rk",
//            value = @Queue("queue.sql.main")
//    ))
//    @RabbitHandler
//    public void consumerSql(Message message) {
//        log.info("consumer sql:{}", message);
//    }

    @RabbitListener(queues = MQConst.QUEUES_SQL_MAIN)
    public void consumerSql(String msg) {
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(msg, SqlMapping.SqlMessage.class);
        log.debug("consumer sql ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("batchSqls result of execution:{}", rstBatchSqls);
        } catch (Exception e) {
            log.error("error:sqlMessage:{}", JsonUtils.toJson(sqlMessage), e);
        }
    }

    // 订单创建
    @RabbitListener(queues = MQConst.QUEUES_SQL_ORDER_CREATE)
    public void consumerOrderCreate(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CREATE   ===");
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("consumer sql_order_create ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql_order_create ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("CONSUMER_ORDER_CREATE result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), true);
            } else {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            }
        } catch (Exception e) {
            log.error("error:sqlMessage:{}", JsonUtils.toJson(sqlMessage), e);
        }
    }

    //订单再次支付
    @RabbitListener(queues = MQConst.QUEUES_SQL_ORDER_AGAIN)
    public void consumerOrderPayAgain(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_PAY_AGAIN   ===");
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("consumer sql_order_create ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql_order_create ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("CONSUMER_ORDER_PAY_AGAIN result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), true);
            } else {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            }
        } catch (Exception e) {
            log.error("error:sqlMessage:{}", JsonUtils.toJson(sqlMessage), e);
        }
    }

    //订单关闭
    @RabbitListener(queues = MQConst.QUEUES_SQL_ORDER_CLOSE)
    public void consumerOrderClose(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CLOSE   ===");
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("consumer sql_order_create ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql_order_create ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("CONSUMER_ORDER_CLOSE result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), true);
            } else {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            }
        } catch (Exception e) {
            log.error("error:sqlMessage:{}", JsonUtils.toJson(sqlMessage), e);
        }
    }

    //订单支付
    @RabbitListener(queues = MQConst.QUEUES_SQL_ORDER_PAY)
    public void consumerOrderPay(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_PAY   ===");
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("consumer sql_order_create ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql_order_create ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("CONSUMER_ORDER_PAY result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), true);
            } else {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            }
        } catch (Exception e) {
            log.error("error:sqlMessage:{}", JsonUtils.toJson(sqlMessage), e);
        }
    }

    //缺票登记
    @RabbitListener(queues = MQConst.QUEUES_SQL_PERFORMANCE_LACK)
    public void consumerPerformanceLack(Message msg, Channel channel) {
        log.info("===   CONSUMER_PERFORMANCE_LACK   ===");
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("consumer sql_performance_lack ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql_performance_lack ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("CONSUMER_PERFORMANCE_LACK result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), true);
            } else {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            }
        } catch (Exception e) {
            log.error("error:sqlMessage:{}", JsonUtils.toJson(sqlMessage), e);
        }
    }
}
