package com.liquidnet.service.candy.dto.admin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Pattern;

@ApiModel(value = "CandyCouponRuleBuildParam", description = "添加券规则入参")
@Data
public class CandyCouponRuleBuildParam {
    @Pattern(regexp = "\\b(100|90|91|92|80|81)\\b", message = "适用范围无效")
    @ApiModelProperty(required = true, value = "适用范围[100-全场｜90-演出｜91-场次｜92-票｜80-商品｜81-款式]", allowableValues = "100,90,91,92,80,81")
    private Integer useScope;
    @ApiModelProperty(required = true, value = "适用名称", allowableValues = "适用名称")
    private String busiName;
    @ApiModelProperty(required = false, value = "适用ID", allowableValues = "适用ID")
    private String busiId;
}
