package com.liquidnet.service.goblin.controller.manage;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCertificationParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCompleteParam;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtCertificationService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

@ApiSupport(order = 149001)
@Api(tags = "店铺认证")
@Slf4j
@Validated
@RestController
@RequestMapping("store/mgt/cert")
public class GoblinStoreMgtCertificationController {
    @Autowired
    IGoblinStoreMgtCertificationService goblinStoreMgtCertificationService;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;
    @Autowired
    GoblinRedisUtils goblinRedisUtils;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "店铺认证第一步:认证资料")
    @PostMapping("fstep")
    public ResponseDto<Object> certificationFirstStep(@Valid @RequestBody GoblinStoreMgtCertificationParam certificationParam) {
        if (log.isDebugEnabled()) {
            log.debug("店铺认证[GoblinStoreMgtCertificationParam:{}]", JsonUtils.toJson(certificationParam));
        }
        goblinStoreMgtCertificationService.certificationInformationProcessing(certificationParam);
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "店铺认证第二步:完善信息")
    @PostMapping("sstep")
    public ResponseDto<Object> certificationSecondStep(@Valid @RequestBody GoblinStoreMgtCompleteParam completeParam) {
        if (log.isDebugEnabled()) {
            log.debug("店铺认证[GoblinStoreMgtCompleteParam:{}]", JsonUtils.toJson(completeParam));
        }
        goblinStoreMgtCertificationService.certificationCompleteProcessing(completeParam);
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "店铺认证编辑中:资料详情")
    @PostMapping("einfo")
    public ResponseDto<GoblinStoreInfoVo> certificationInfo() {
        return ResponseDto.success(goblinRedisUtils.getStoreInfoVoByUid(CurrentUtil.getCurrentUid()));
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "店铺认证认证中:店铺状态", notes = "认证状态[-1-未申请|0-填写资料中|1-店铺审核中|2-审核不通过|3-审核通过|4-停业|5-营业]")
    @PostMapping("status")
    public ResponseDto<String> certificationStatus() {
        GoblinStoreInfoVo storeInfoVo = goblinRedisUtils.getStoreInfoVoByUid(CurrentUtil.getCurrentUid());
        return ResponseDto.success(null == storeInfoVo ? "-1" : storeInfoVo.getStatus());
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "店铺认证编辑中:删除店铺")
    @PostMapping("cancel")
    public ResponseDto<Object> certificationCancel(String storeId) {
        GoblinStoreInfoVo storeInfoVo = goblinRedisUtils.getStoreInfoVo(storeId);
        if (null != storeInfoVo) {
            if (goblinMongoUtils.delStoreInfoVo(storeId)) {
                goblinRedisUtils.delStoreIdByUid(CurrentUtil.getCurrentUid());
                goblinRedisUtils.delStoreInfoVo(storeId);
            }
        }
        return ResponseDto.success();
    }
}
