package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.service.goblin.dto.vo.GoblinServiceSupportVo;
import com.liquidnet.service.goblin.service.manage.IGoblinMgtServiceSupportService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service
public class GoblinMgtServiceSupportServiceImpl implements IGoblinMgtServiceSupportService {
    @Autowired
    private GoblinMongoUtils goblinMongoUtils;

    @Override
    public List<GoblinServiceSupportVo> list() {
        List<GoblinServiceSupportVo> serviceSupportVos = goblinMongoUtils.getMgtServiceSupportVos();
        if (CollectionUtils.isEmpty(serviceSupportVos)) {
            serviceSupportVos.add(GoblinServiceSupportVo.getNew().setName("正品保证").setDesc("商品为正版行货").setSsid("101"));
            serviceSupportVos.add(GoblinServiceSupportVo.getNew().setName("极速发货").setDesc("24小时内发送货物").setSsid("102"));
            serviceSupportVos.add(GoblinServiceSupportVo.getNew().setName("无忧退货").setDesc("支持7天无理由退款").setSsid("103"));

            List<GoblinServiceSupportVo> serviceSupportVoList = goblinMongoUtils.insertMgtServiceSupportVos(serviceSupportVos);
            // TODO: 2022/1/4 zhanggb + queue.sql
        }
        return serviceSupportVos;
    }
}
