package com.liquidnet.service.goblin.dto.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 订单单品表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinOrderSkuVo implements Serializable, Cloneable {

    @ApiModelProperty(value = "订单sku_id")
    private String orderSkuId;
    @ApiModelProperty(value = "订单id")
    private String orderId;
    @ApiModelProperty(value = "商品id")
    private String spuId;
    @ApiModelProperty(value = "款式id")
    private String skuId;
    @ApiModelProperty(value = "数量")
    private Integer num;
    @ApiModelProperty(value = "订单状态[0-待付款(用户刚下单)|2-代发货(用户付完款 等待商城发货)|3-代收货(商城已经发货 等待用户确认收货)|4-已完成(用户已经确认收货 订单结束)|5-取消订单(用户未付款前取消订单)|6-退款通过(用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款)|7-退货通过(用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品)|61-6的发起状态|71-7的发起状态]")
    private int status;
    @ApiModelProperty(value = "款式原价")
    private BigDecimal skuPrice;
    @ApiModelProperty(value = "款式实付价")
    private BigDecimal skuPriceActual;
    @ApiModelProperty(value = "退款价格")
    private BigDecimal priceRefund;
    @ApiModelProperty(value = "款式名称")
    private String skuName;
    @ApiModelProperty(value = "款式编号")
    private String skuNo;
    @ApiModelProperty(value = "款式图片")
    private String skuImage;
    @ApiModelProperty(value = "款式规格")
    private String skuSpecs;
    @ApiModelProperty(value = "管理员优惠价格")
    private BigDecimal priceModify;
    @ApiModelProperty(value = "款式最终优惠价")
    private BigDecimal priceVoucher;
    @ApiModelProperty(value = "创建时间")
    private String createdAt;

    private static final GoblinOrderSkuVo obj = new GoblinOrderSkuVo();

    public static GoblinOrderSkuVo getNew() {
        try {
            return (GoblinOrderSkuVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinOrderSkuVo();
        }
    }
}
