package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.IGoblinAppZhengzaiService;
import com.liquidnet.service.goblin.util.*;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;

@Service
public class GoblinAppZhengzaiServiceImpl implements IGoblinAppZhengzaiService {

    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinOrderUtils orderUtils;


    @Override
    public List<GoblinSelfMarketingVo> getZhengzaiMarketList() {
        List<GoblinSelfMarketingVo> list = redisUtils.getGoblinSelfMarketingVoList();
        List<GoblinSelfMarketingVo> voList = ObjectUtil.getGoblinSelfMarketingVoList();
        LocalDateTime now = LocalDateTime.now();
        for (GoblinSelfMarketingVo item : list) {
            if (LocalDateTime.parse(item.getStartTime(), DTF_YMD_HMS).isBefore(now) && LocalDateTime.parse(item.getEndTime(), DTF_YMD_HMS).isAfter(now)) {
                voList.add(item);
            }
        }
        return voList;
    }

    @Override
    public List<GoblinShowStoreInfoVo> getStoreList(String marketId) {
        List<GoblinMarketRelationVo> relationVo = redisUtils.getMarketRelation(GoblinStatusConst.MarketPreStatus.MARKET_PRE_ZHENGZAI.getValue(), marketId);
        List<String> storeIdList = relationVo.stream().map(GoblinMarketRelationVo::getStoreId).collect(Collectors.toList());
        List<GoblinShowStoreInfoVo> voList = ObjectUtil.getGoblinShowStoreInfoVoArrayList();
        for (String storeId : storeIdList) {
            GoblinStoreInfoVo vo = redisUtils.getStoreInfoVo(storeId);
            if (vo.getStatus().equals("5")) {
                GoblinShowStoreInfoVo returnVo = GoblinShowStoreInfoVo.getNew();
                BeanUtils.copyProperties(vo, returnVo);
                voList.add(returnVo);
            }
        }
        return voList;
    }

    @Override
    public List<GoblinZhengzaiGoodVo> getSpuList(String marketId, String storeId) {
        List<GoblinMarketRelationVo> relationVo = redisUtils.getMarketRelation(GoblinStatusConst.MarketPreStatus.MARKET_PRE_ZHENGZAI.getValue(), marketId);
        List<String> spuIdList = relationVo.stream().map(GoblinMarketRelationVo::getSpuId).collect(Collectors.toList());
        List<GoblinZhengzaiGoodVo> voList = ObjectUtil.getGoblinZhengzaiGoodVoArrayList();
        for (String spuId : spuIdList) {
            GoblinGoodsInfoVo vo = redisUtils.getGoodsInfoVo(spuId);
            if (vo.getStatus().equals("3") && storeId.equals(vo.getStoreId())) {
                GoblinZhengzaiGoodVo returnVo = GoblinZhengzaiGoodVo.getNew();
                BeanUtils.copyProperties(vo, returnVo);
                voList.add(returnVo);
            }
        }
        return voList;
    }

    @Override
    public ResponseDto<List<GoblinZhengzaiPushVo>> orderPush(String masterCode) {
        String[] orderIds = redisUtils.getMasterCode(masterCode);
        List<GoblinZhengzaiPushVo> listVo = ObjectUtil.getGoblinZhengzaiPushVoArrayList();
        LocalDateTime now = LocalDateTime.now();
        if (orderIds == null) {
            return ResponseDto.failure("订单不存在");
        } else {
            for (String orderId : orderIds) {
                GoblinStoreOrderVo storeOrderVo = redisUtils.getGoblinOrder(orderId);
                List<String> skuIds = storeOrderVo.getOrderSkuVoIds();
                for (String skuId:skuIds){
                    GoblinZhengzaiPushVo vo = GoblinZhengzaiPushVo.getNew();
                    GoblinOrderSkuVo skuInfoVo = redisUtils.getGoblinOrderSkuVo(skuId);
                    vo.setSkuName(skuInfoVo.getSkuName());
                    vo.setNum(skuInfoVo.getNum());
                    vo.setSkuSpecs(skuInfoVo.getSkuSpecs());
                    vo.setSpuName("");//todo 胡佳晨
                }
            }
        }
        return ResponseDto.success(listVo);
    }

    @Override
    public ResponseDto<Boolean> orderBind(String uid, String masterCode) {
        String[] orderIds = redisUtils.getMasterCode(masterCode);
        LocalDateTime now = LocalDateTime.now();
        BigDecimal priceActual = BigDecimal.ZERO;
        if (orderIds == null) {
            return ResponseDto.failure("订单不存在");
        } else {
            for (String orderId : orderIds) {
                GoblinStoreOrderVo storeOrderVo = redisUtils.getGoblinOrder(orderId);
                if (storeOrderVo.getUserId().equals(uid)) {
                    continue;
                }
                storeOrderVo.setUserId(orderId);
                priceActual = priceActual.add(storeOrderVo.getPriceActual());
                //mongo
                mongoUtils.updateGoblinStoreOrderVo(storeOrderVo.getOrderId(), storeOrderVo);
                //redis
                redisUtils.setGoblinOrder(storeOrderVo.getOrderId(), storeOrderVo);
                //mysql
                queueUtils.sendMsgByRedis(MQConst.GoblinQueue.GOBLIN_ORDER_CREATE_PAY.getKey(),
                        SqlMapping.get("goblin_order.zhengzai.bind",
                                uid, now, storeOrderVo.getOrderId(), now, now));
            }
            if (priceActual.compareTo(BigDecimal.ZERO) != 0) {
                orderUtils.doTask(uid, priceActual);
            }
        }
        return ResponseDto.success();
    }
}
