package com.liquidnet.service.adam.dto.vo;

import com.liquidnet.service.adam.entity.AdamMemberRights;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "AdamMemberRightsVo", description = "会员")
@Data
public class AdamMemberRightsVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -2407106925001008460L;
    @ApiModelProperty(position = 1, value = "权益ID")
    private String mrightsId;
    @ApiModelProperty(position = 2, value = "排列序号")
    private Integer seqNo;
    @ApiModelProperty(position = 3, value = "权益标题")
    private String title;
    @ApiModelProperty(position = 4, value = "副标题")
    private String subTitle;
    @ApiModelProperty(position = 5, value = "标注")
    private String label;
    @ApiModelProperty(position = 6, value = "图片标识")
    private String cover;
    @ApiModelProperty(position = 7, value = "详情内容")
    private String detail;

    public AdamMemberRightsVo setSeqNo(Integer seqNo) {
        this.seqNo = seqNo;
        return this;
    }

    public AdamMemberRightsVo setTitle(String title) {
        this.title = title;
        return this;
    }

    public AdamMemberRightsVo setCover(String cover) {
        this.cover = cover;
        return this;
    }

    private static final AdamMemberRightsVo obj = new AdamMemberRightsVo();

    public static AdamMemberRightsVo getNew() {
        try {
            return (AdamMemberRightsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberRightsVo();
        }
    }

    public AdamMemberRightsVo copy(AdamMemberRights source) {
        if (null == source) return this;
        this.setMrightsId(source.getMrightsId());
        this.setSeqNo(source.getSeqNo());
        this.setTitle(source.getTitle());
        this.setSubTitle(source.getSubTitle());
        this.setLabel(source.getLabel());
        this.setCover(source.getCover());
        this.setDetail(source.getDetail());
        return this;
    }
}
