package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.SensitizeUtil;
import com.liquidnet.service.adam.dto.AdamUserInfoDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@ApiModel(value = "AdamUserInfoVo", description = "用户详情")
@Data
public class AdamUserInfoSimpleVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 8479869354894030303L;
    @ApiModelProperty(position = 10, value = "用户ID[64]")
    private String uid;
    @ApiModelProperty(position = 11, value = "手机号[20]")
    private String mobile;
    @ApiModelProperty(position = 14, value = "昵称[32]")
    private String nickname;

    private static final AdamUserInfoSimpleVo obj = new AdamUserInfoSimpleVo();

    public static AdamUserInfoSimpleVo getNew() {
        try {
            return (AdamUserInfoSimpleVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamUserInfoSimpleVo();
    }
}
