package com.liquidnet.service.platform.controller.candy;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.constant.LnsRegex;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.dto.CandyCommonCouponBasicDto;
import com.liquidnet.service.candy.dto.CandyUserCouponBasicDto;
import com.liquidnet.service.platform.service.impl.candy.PlatformCandyUserCouponService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.List;
import java.util.regex.Pattern;

@Api(tags = "券列表-数据降级查询")
@Slf4j
@RestController
@RequestMapping("cdemote")
public class PlatformCandyDemoteController {
    @Autowired
    private PlatformCandyUserCouponService platformCandyUserCouponService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "私有券")
    @GetMapping("ucoupon")
    public ResponseDto<List<CandyUserCouponBasicDto>> queryForUserCouponBasicDto(@RequestParam String currentUid) {
        List<CandyUserCouponBasicDto> basicDtoList = null;
        if (StringUtils.isNotBlank(currentUid)) {
            basicDtoList = platformCandyUserCouponService.ucouponBasicDtoByUidProcessing(currentUid);
        }
        return ResponseDto.success(basicDtoList);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "公有券")
    @GetMapping("ccoupon")
    public ResponseDto<List<CandyCommonCouponBasicDto>> queryForCommonCouponBasicDto(@RequestParam String ucreatedAtStr) {
        List<CandyCommonCouponBasicDto> basicDtoList = null;
        if (StringUtils.isNotBlank(ucreatedAtStr) && Pattern.matches(LnsRegex.Valid.DATETIME_FULL, ucreatedAtStr)) {
            LocalDateTime ucreatedAt = DateUtil.Formatter.yyyyMMddHHmmss.parse(ucreatedAtStr);

            basicDtoList = platformCandyUserCouponService.ccouponBasicDtoByUidProcessing(ucreatedAt);
        }
        return ResponseDto.success(basicDtoList);
    }

}
