package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.commons.lang.constant.LnsRegex;
import com.liquidnet.service.goblin.dto.GoblinGoodsSpecDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtGoodsCouponAddSkuParam", description = "商品管理:添加券类商品:添加券SKU入参")
@Data
public class GoblinStoreMgtGoodsCouponAddSkuParam implements Serializable {
    private static final long serialVersionUID = 7886534346305369761L;
    @ApiModelProperty(position = 10, required = false, value = "单品ID[编辑时必传]")
    private String skuId;
    @ApiModelProperty(position = 11, required = false, value = "单品编码[默认为系统编码，也可手动输入商家自己的编码]")
    @Pattern(regexp = LnsRegex.Valid.ALPHABET_NUMBER_UNDER_50, message = "单品编码格式或长度有误")
    private String skuNo;
    @ApiModelProperty(position = 12, required = false, value = "单品条码")
    @Pattern(regexp = LnsRegex.Valid.ALPHABET_NUMBER_32, message = "单品条码格式或长度有误")
    private String skuBarCode;
    @ApiModelProperty(position = 13, required = false, value = "ERP商家编码")
    @Size(max = 40, message = "ERP商家编码长度限制40")
    private String skuErpCode;//-
    @ApiModelProperty(position = 14, required = false, value = "ERP托管[0-否|1-是]，默认0")
    @Pattern(regexp = "\\b(0|1)\\b", message = "ERP托管参数无效")
    private String erpHosting;//-
    @ApiModelProperty(position = 15, required = false, value = "ERP仓库编号")
    @Size(max = 40, message = "ERP仓库编号长度限制40")
    private String erpWarehouseNo;//-
    @ApiModelProperty(position = 16, required = false, value = "单品默认图片的url[256]")
    @NotBlank(message = "单品图片不能为空")
    private String skuPic;
    @ApiModelProperty(position = 12, required = false, value = "单品规格信息")
    @NotNull(message = "规格信息不能为空")
//    @Valid// 初始化写死['规格'：'张']
    private List<GoblinGoodsSpecDto> skuSpecList;

    @ApiModelProperty(position = 18, required = false, value = "单品销售价-原价[20,2]")
    private BigDecimal sellPrice;
    @ApiModelProperty(position = 19, required = true, value = "单品现价[20,2]")
    @Digits(integer = 6, fraction = 2, message = "参数'单品现价'无效")
    @DecimalMin(value = "0.01", message = "参数'单品现价'必须为大于0")
    private BigDecimal price;
    @ApiModelProperty(position = 20, required = false, value = "单品会员价格[20,2]")
    @NotNull(message = "单品会员价格不能为空")
    @Min(value = 0, message = "单品会员价格不能小于0")
    private BigDecimal priceMember;
    @ApiModelProperty(position = 21, required = false, value = "单品的重量[20,2]")
    private BigDecimal weight;//-
    @ApiModelProperty(position = 20, required = true, value = "总库存")
    @Min(value = 0, message = "总库存不能小于0")
    private Integer stock;
    @ApiModelProperty(position = 21, required = false, value = "预警库存")
    private Integer warningStock;
    @ApiModelProperty(position = 22, required = false, value = "ISBN，针对CD/图书等[100]")
    private String skuIsbn;//-
    @ApiModelProperty(position = 23, required = false, value = "购买限制[0-全部用户|1-仅会员|2-指定用户]")
    @NotNull(message = "购买限制不能为空")
    private String buyFactor;
    @ApiModelProperty(position = 24, required = false, value = "购买限制人员名单[购买限制为2-指定用户时必填]")
    private String buyRoster;
    @ApiModelProperty(position = 25, required = false, value = "限量[0-无限制|X:限购数量]")
    private Integer buyLimit;
    @ApiModelProperty(position = 26, required = false, value = "单品有效期[yyyy-MM-dd HH:mm:ss]")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "单品有效期格式有误")
    private String skuValidity;
    @ApiModelProperty(position = 27, value = "自定义展示[0-默认展示|1-隐藏不可购买]")
    private String skuAppear;

    /**
     * ---------------------------- 券类商品-代金券属性 ----------------------------
     */

    @ApiModelProperty(position = 28, required = true, value = "是否实名[0-否｜1-是，表示该商品需要实名关联]", allowableValues = "0,1",  example = "1")
    @Pattern(regexp = "\\b(0|1)\\b", message = "参数'是否实名'无效")
    private Integer isTrueName;
    @ApiModelProperty(position = 29, required = true, value = "适用范围[101-音乐节｜102-小型演出（livehouse演出）｜103-巡演]", allowableValues = "101,102,103", example = "101")
    @Pattern(regexp = "\\b(101|102|103)\\b", message = "参数'适用范围'无效")
    private Integer useScope;
    @ApiModelProperty(position = 30, required = true, value = "面值", example = "99.00")
    @Digits(integer = 3, fraction = 2, message = "参数'面值'无效")
    @DecimalMin(value = "0.01", message = "参数'面值'必须为大于0")
    private BigDecimal valFace;
    @ApiModelProperty(position = 31, required = true, value = "开始时间[yyyy-MM-dd HH:mm:ss]", example = "2024-01-01 00:00:00")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "开始时间格式有误")
    @NotNull(message = "参数'开始时间'不可为空")
    private String effectTime;
    @ApiModelProperty(position = 32, required = true, value = "结束时间[yyyy-MM-dd HH:mm:ss]", example = "2024-12-31 00:00:00")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "结束时间格式有误")
    @NotNull(message = "参数'结束时间'不可为空")
    private String expireTime;
}
