package com.liquidnet.service.stone.vo;

import com.liquidnet.service.stone.entity.StoneScoreItems;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 积分物品表
 * </p>
 *
 * @author liquidnet
 * @since 2021-10-19
 */
@Data
@ApiModel
public class StoneScoreItemVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(position = 0, value = "积分物品id")
    private String itemId;

    @ApiModelProperty(position = 1, value = "积分物品名称")
    private String targetTitle;

    @ApiModelProperty(position = 2, value = "目标类型[1-券|1x-商品维度|2x-演出维度]")
    private Integer type;

    @ApiModelProperty(position = 3, value = "展示图")
    private String img;

    @ApiModelProperty(position = 4, value = "所需积分")
    private Integer score;

    @ApiModelProperty(position = 5, value = "所需金额")
    private BigDecimal price;

    @ApiModelProperty(position = 6, value = "限购数量[0-不限]")
    private Integer limitCount;

    @ApiModelProperty(position = 7, value = "商品详情")
    private String details;

    @ApiModelProperty(position = 8, value = "注意事项")
    private String notice;

    @ApiModelProperty(position = 9, value = "状态[-999-全部|-1-删除|0-未上架|1-已上架|2-定时上架|7-已下架|8-售罄]")
    private Integer status;

    private static final StoneScoreItemVo obj = new StoneScoreItemVo();

    public static StoneScoreItemVo getNew() {
        try {
            return (StoneScoreItemVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new StoneScoreItemVo();
        }
    }

    public StoneScoreItemVo copy(StoneScoreItems source) {
        if (null == source) return this;
        this.setItemId(source.getItemId());
        this.setTargetTitle(source.getTargetTitle());
        this.setType(source.getType());
        this.setImg(source.getImg());
        this.setScore(source.getScore().intValue());
        this.setPrice(source.getPrice());
        this.setLimitCount(source.getLimitCount());
        this.setDetails(source.getDetails());
        this.setNotice(source.getNotice());
        LocalDateTime now = LocalDateTime.now();
        if (source.getStatus() == 2) {
            if (now.isAfter(source.getStartTime())) {//未上架
                this.setStatus(2);
            } else if (now.isBefore(source.getEndTime())) {//已下架
                this.setStatus(7);
            } else {
                this.setStatus(1);//上架中
            }
        }else{
            this.setStatus(source.getStatus());
        }
        return this;
    }
}
