package com.liquidnet.client.admin.zhengzai.smile.utils;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class SmileRedisUtils {

    @Autowired
    RedisDataSourceUtil redisDataSourceUtil;

    public Boolean set(String key, Object value){
        return redisDataSourceUtil.getRedisSweetUtil().set(key, value);
    }

    public Object get(String key){
        return redisDataSourceUtil.getRedisSweetUtil().get(key);
    }

    public void del(String s) {
        redisDataSourceUtil.getRedisSweetUtil().del(s);
    }

    public boolean hset(String key, String item, Object value){
        return redisDataSourceUtil.getRedisAdamUtil().hset(key,item,value);
    }

    public boolean lSet(String key, Object value){
        return redisDataSourceUtil.getRedisSweetUtil().lSet(key,value);
    }

    public boolean lSet(String key, List<Object> value){
        return redisDataSourceUtil.getRedisSweetUtil().lSet(key,value);
    }

    public  List<Object> lGet(String key, long start, long end) {
        return redisDataSourceUtil.getRedisSweetUtil().lGet(key, start, end);
    }

    public long lGetListSize(String key) {
        return redisDataSourceUtil.getRedisSweetUtil().lGetListSize(key);
    }

    public Object lGetIndex(String key, long index) {
        return redisDataSourceUtil.getRedisSweetUtil().lGetIndex(key,index);
    }

    public long lRemove(String key, long count, Object value){
        return redisDataSourceUtil.getRedisSweetUtil().lRemove(key, count, value);
    }

    public boolean hasKey(String key) {
        return redisDataSourceUtil.getRedisSweetUtil().hasKey(key);
    }
}
