package com.liquidnet.service.slime.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.slime.dto.param.SlimeAuthorizationRecordParam;
import com.liquidnet.service.slime.dto.vo.SlimeAuthorizationPerformanceVo;
import com.liquidnet.service.slime.dto.vo.SlimeAuthorizationRecordsVo;
import com.liquidnet.service.slime.service.ISlimeAuthorizationRecordsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * <p>
 * 授权 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-11-18
 */
@ApiSupport(order = 10003)
@Api(tags = "授权")
@Slf4j
@Validated
@RestController
@RequestMapping("authorizations")
public class SlimeAuthorizationsController {

    @Autowired
    ISlimeAuthorizationRecordsService authorizationRecordsService;

    @ApiOperationSupport(order = 10)
    @ApiOperation(value = "演出下全部权限")
    @GetMapping("info")
    public ResponseDto<SlimeAuthorizationPerformanceVo> authorizationInfo(@RequestParam(required = true) @NotBlank(message = "演出ID不能为空")  String performanceId) {
        String currentUid = CurrentUtil.getCurrentUid();

        return ResponseDto.success(authorizationRecordsService.performanceAuthorization(currentUid, performanceId));
    }

    @ApiOperationSupport(order = 20)
    @ApiOperation(value = "授权记录列表")
    @GetMapping("records")
    public ResponseDto<List<SlimeAuthorizationRecordsVo>> recordsCheckers(@RequestParam(required = true) @NotBlank(message = "演出ID不能为空") String performanceId) {
        String currentUid = CurrentUtil.getCurrentUid();

        return ResponseDto.success(authorizationRecordsService.performanceRecordCheckers(currentUid, performanceId));
    }

    @ApiOperationSupport(order = 21)
    @ApiOperation(value = "添加授权记录")
    @PostMapping("records/add")
    public ResponseDto<Object> recordsCheckerAdd(@Valid @RequestBody SlimeAuthorizationRecordParam parameter) {
        String currentUid = CurrentUtil.getCurrentUid();

        return ResponseDto.success(authorizationRecordsService.performanceRecordCheckerAdd(currentUid, parameter));
    }

    @ApiOperationSupport(order = 22)
    @ApiOperation(value = "删除授权记录")
    @PostMapping("records/del")
    public ResponseDto<Object> recordsCheckerDel(@RequestParam(required = true) @NotBlank(message = "授权ID不能为空")  String authorizationRecordId) {
        String currentUid = CurrentUtil.getCurrentUid();

        authorizationRecordsService.performanceRecordCheckerDel(currentUid, authorizationRecordId);

        return ResponseDto.success();
    }
}
