package com.liquidnet.service.goblin.controller.Inner;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.erp.config.ErpWdtClient;
import com.liquidnet.service.erp.constant.ErpEnum;
import com.liquidnet.service.erp.param.TradeListParam;
import com.liquidnet.service.erp.vo.TradePushVo;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreZhengzaiCommonParam;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.manage.IGoblinConsumerService;
import com.liquidnet.service.goblin.service.manage.IGoblinInnerService;
import com.liquidnet.service.goblin.service.manage.IGoblinZhengzaiService;
import com.liquidnet.service.goblin.util.GoblinOrderUtils;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 正在下单活动管理
 */
@Slf4j
@RestController
@Api(tags = "活动-内部接口调用")
@RequestMapping("inner")
public class GoblinInnerZhengzaiController {

    @Autowired
    IGoblinZhengzaiService goblinZhengzaiService;
    @Autowired
    IGoblinInnerService goblinInnerService;
    @Autowired
    IGoblinConsumerService goblinConsumerService;

    @PostMapping("config/del/noAuth")
    @ApiOperation("活动详情-正在下单-删除商铺spu")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "selfMarketId", value = "官方活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "spuId", value = "spuId", example = "1"),
    })
    public ResponseDto<Boolean> zhengzaiStoreDelNoAuth(@RequestParam("storeId") @Valid String storeId,
                                                       @RequestParam("selfMarketId") @Valid String selfMarketId,
                                                       @RequestParam("spuId") @Valid String spuId) {
        return goblinZhengzaiService.zhengzaiSpuDel(selfMarketId, storeId, spuId);
    }

    @GetMapping("config/spu")
    @ApiOperation("活动详情-正在下单-获取商铺spu")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "selfMarketId", value = "官方活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "page", value = "页数", example = "1")
    })
    public ResponseDto<PageInfo<GoblinMarketSpuListVo>> zhengzaiStoreConfigSpuList(@RequestParam("storeId") @Valid String storeId,
                                                                                   @RequestParam("selfMarketId") @Valid String selfMarketId,
                                                                                   @RequestParam("page") @Valid int page) {
        return goblinZhengzaiService.zhengzaiSpuList(selfMarketId, storeId, page);
    }

    @GetMapping("config/sku")
    @ApiOperation("活动详情-正在下单-获取商铺sku")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "selfMarketId", value = "官方活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "spuId", value = "spuId", example = "1")
    })
    public ResponseDto<List<GoblinSelfZhengzaiSkuVo>> zhengzaiStoreConfigSkuList(@RequestParam("storeId") @Valid String storeId,
                                                                                 @RequestParam("spuId") @Valid String spuId,
                                                                                 @RequestParam("selfMarketId") @Valid String selfMarketId) {
        return goblinZhengzaiService.zhengzaiSkuList(selfMarketId, storeId, spuId);
    }

    @PostMapping("add/temp/coupon")
    @ApiOperation("添加活动临时券")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "File", name = "file", value = "文件", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "performanceId", value = "演出id", required = true),
    })
    public ResponseDto<String> insertCoupon(@RequestParam("file") MultipartFile file,
                                            @RequestParam("performanceId") String performanceId) {
        return goblinInnerService.insertCoupon(file, performanceId);
    }

    @PostMapping("ar/data")
    @ApiOperation("获取ar相关离线数据")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "tag", value = "标签", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "performanceId", value = "演出id", required = true),
    })
    public ResponseDto<ArDataVo> getArData(@RequestParam("tag") String tag,
                                           @RequestParam("performanceId") String performanceId) {
        return goblinInnerService.getArData(tag, performanceId);
    }

    @PostMapping("temp/coupon/data")
    @ApiOperation("获取临时券数据")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "ucouponId", value = "券id", required = true),
    })
    public ResponseDto<TempCouponVo> getArData(@RequestParam("ucouponId") String ucouponId) {
        return goblinInnerService.getTempCouponData(ucouponId);
    }

    @PostMapping("consumerType12")
    @ApiOperation("xls 类型1/2")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "finalSkuId", value = "skuId"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "finalType", value = "类型"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "xlsPath", value = "文件地址"),
    })
    public ResponseDto<Boolean> consumerType12(String finalSkuId, Integer finalType, String xlsPath) {
        return goblinConsumerService.consumerType12(finalSkuId, finalType, xlsPath);
    }

    @PostMapping("consumerType34")
    @ApiOperation("xls 类型3/4")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "finalSkuId", value = "skuId"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "finalType", value = "类型"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "xlsPath", value = "文件地址"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "oXlsPath", value = "文件地址2"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "listId", value = "分批购活动id"),
    })
    public ResponseDto<Boolean> consumerType34(String finalSkuId, Integer finalType, String xlsPath, String oXlsPath, String listId) {
        return goblinConsumerService.consumerType34(finalSkuId, finalType, xlsPath, oXlsPath, listId);
    }


//    @Autowired
//    GoblinOrderUtils goblinOrderUtils;
//    @Autowired
//    private ErpWdtClient erpWdtClient;
//
//    @PostMapping("test112233")
//    @ApiOperation("测试11")
//    @ApiImplicitParams({
//            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "orderId"),
//    })
//    public ResponseDto<TradePushVo> test112233(String orderId) {
////        List<TradeListParam> aa = goblinOrderUtils.getErpOrder(orderId);
////        log.info("data = " + JSON.toJSONString(aa));
////        return ResponseDto.success();
//
//
//        Map<String, String> param = CollectionUtil.linkMapStringString();
//        param.put("shop_no", "mdtk2-test");
////        List<HashMap<String, Object>> tradeList = new ArrayList<>();
////        tradeList.add(TradeListParam.getNew().test(num));
//        param.put("trade_list", JSON.toJSONString(goblinOrderUtils.getErpOrder(orderId)));
//        String json = erpWdtClient.execute(ErpEnum.WdtAPI.TRADE_PUSH.getUri(), param);
//        TradePushVo data = JsonUtils.fromJson(json, TradePushVo.class);
//        return ResponseDto.success(data);
//    }
}
