package com.liquidnet.service.platform.controller;

import com.alibaba.fastjson.JSON;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.erp.config.ErpWdtClient;
import com.liquidnet.service.erp.constant.ErpEnum;
import com.liquidnet.service.erp.param.LogisticsListParam;
import com.liquidnet.service.erp.param.TradeListParam;
import com.liquidnet.service.erp.vo.LogisticSyncAckBaseVo;
import com.liquidnet.service.erp.vo.LogisticSyncBaseVo;
import com.liquidnet.service.erp.vo.StockQueryBaseVo;
import com.liquidnet.service.erp.vo.TradePushVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(tags = "erp测试接口")
@Slf4j
@RestController
@RequestMapping("test/erp")
public class ErpTestController {

    @Autowired
    private ErpWdtClient erpWdtClient;

    @PostMapping("stockQuery")
    @ApiOperation("增量库存查询")
    public ResponseDto<StockQueryBaseVo> stockQuery(@RequestParam("st") String st, @RequestParam("et") String et) {
        Map<String, String> param = CollectionUtil.linkMapStringString();
        param.put("start_time", st);
        param.put("end_time", et);
        param.put("warehouse_no", "mdtk2-test");
        param.put("spec_no", "mdsk01");
        String json = erpWdtClient.execute(ErpEnum.WdtAPI.STOCK_QUERY.getUri(), param);
        StockQueryBaseVo data = JsonUtils.fromJson(json, StockQueryBaseVo.class);
        return ResponseDto.success(data);
    }

    @PostMapping("tradePush")
    @ApiOperation("创建原始单")
    public ResponseDto<TradePushVo> tradePush(@RequestParam("num") String num) {
        Map<String, String> param = CollectionUtil.linkMapStringString();
        param.put("shop_no", "mdtk2-test");
        List<HashMap<String, Object>> tradeList = new ArrayList<>();
        tradeList.add(TradeListParam.getNew().test(num));
        param.put("trade_list", JSON.toJSONString(tradeList));
        String json = erpWdtClient.execute(ErpEnum.WdtAPI.TRADE_PUSH.getUri(), param);
        TradePushVo data = JsonUtils.fromJson(json, TradePushVo.class);
        return ResponseDto.success(data);
    }


    @PostMapping("syncQuery")
    @ApiOperation("查询物流同步")
    public ResponseDto<LogisticSyncBaseVo> syncQuery() {
        Map<String, String> param = CollectionUtil.linkMapStringString();
        param.put("shop_no", "mdtk2-test");
        param.put("limit", "100");
        param.put("is_part_sync_able","1");
        String json = erpWdtClient.execute(ErpEnum.WdtAPI.LOGISTICS_SYNC_QUERY.getUri(), param);
        LogisticSyncBaseVo data = JsonUtils.fromJson(json, LogisticSyncBaseVo.class);
        return ResponseDto.success(data);
    }

    @PostMapping("syncAck")
    @ApiOperation("物流同步回写")
    public ResponseDto<LogisticSyncAckBaseVo> syncAck(@RequestParam("recId") int recId,@RequestParam("status") int status) {
        Map<String, String> param = CollectionUtil.linkMapStringString();
        param.put("shop_no", "mdtk2-test");
        param.put("limit", "100");
        param.put("is_part_sync_able","1");
        List<Map<String, Object>> logisticsList = new ArrayList<>();
        logisticsList.add(LogisticsListParam.getNew().test(recId,status));
        param.put("logistics_list", JSON.toJSONString(logisticsList));
        String json = erpWdtClient.execute(ErpEnum.WdtAPI.LOGISTICS_SYNC_ACK.getUri(), param);
        LogisticSyncAckBaseVo data = JsonUtils.fromJson(json, LogisticSyncAckBaseVo.class);
        return ResponseDto.success(data);
    }
}
