package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontNavigationService;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinFrontNavigation;
import com.liquidnet.service.goblin.mapper.GoblinFrontNavigationMapper;
import com.mongodb.BasicDBObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 首页导航栏
 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-28
 */
@Service
public class GoblinFrontNavigationServiceImpl extends ServiceImpl<GoblinFrontNavigationMapper, GoblinFrontNavigation> implements IGoblinFrontNavigationService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private GoblinFrontNavigationMapper goblinFrontNavigationMapper;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    public boolean create(GoblinFrontNavigation goblinFrontNavigation){
        goblinFrontNavigation.setCreateTime(LocalDateTime.now());
        //设置金刚位id
        goblinFrontNavigation.setNavigationId(IDGenerator.nextSnowId());
        //mysql插入
        goblinFrontNavigationMapper.insert(goblinFrontNavigation);
      /*  //mongo  db增加
        mongoTemplate.save(goblinFrontNavigation,GoblinFrontNavigation.class.getSimpleName());
        //redis增加
        LambdaQueryWrapper<GoblinFrontNavigation> queryWrapper = Wrappers.lambdaQuery(GoblinFrontNavigation.class);
        queryWrapper.ne(GoblinFrontNavigation::getDelTag,1);
        queryWrapper.orderByDesc(GoblinFrontNavigation::getIndexs);
        List<GoblinFrontNavigation> list=goblinFrontNavigationMapper.selectList(queryWrapper);
        redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_NAVIGATION,list);*/
        return  true;
    }
    public boolean update(GoblinFrontNavigation goblinFrontNavigation){
        goblinFrontNavigation.setUpdateTime(LocalDateTime.now());
        //数据库修改
        goblinFrontNavigationMapper.updateById(goblinFrontNavigation);
        /*//mongodb修改
        BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontNavigation)));
        mongoTemplate.getCollection(GoblinFrontNavigation.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("navigationId").is(goblinFrontNavigation.getNavigationId())).getQueryObject(),
                orderObject
        );
        //redis 修改
          //从数据库中查出来，从新塞进去
        LambdaQueryWrapper<GoblinFrontNavigation> queryWrapper = Wrappers.lambdaQuery(GoblinFrontNavigation.class);
        queryWrapper.ne(GoblinFrontNavigation::getDelTag,1);
        queryWrapper.orderByDesc(GoblinFrontNavigation::getIndexs);
        List<GoblinFrontNavigation> list=goblinFrontNavigationMapper.selectList(queryWrapper);
        redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_NAVIGATION,list);*/
        return true;
    }
    public GoblinFrontNavigation getOne(Long id){
        return  goblinFrontNavigationMapper.selectById(id);
    }
    public boolean delete(Long id){
        GoblinFrontNavigation goblinFrontNavigation=goblinFrontNavigationMapper.selectById(id);
        goblinFrontNavigation.setDelTag(1);
        this.update(goblinFrontNavigation);
        return true;
    }
    public PageInfo<GoblinFrontNavigation> page(int pageSize, int pageNumber, GoblinFrontNavigation goblinFrontNavigation) {
        PageInfo<GoblinFrontNavigation> pageInfoTmp = null;
        try {
            PageHelper.startPage(pageNumber, pageSize);
            LambdaQueryWrapper<GoblinFrontNavigation> queryWrapper = Wrappers.lambdaQuery(GoblinFrontNavigation.class);
            queryWrapper.orderByDesc(GoblinFrontNavigation::getCreateTime);
            List<GoblinFrontNavigation> list=goblinFrontNavigationMapper.selectList(queryWrapper);
            pageInfoTmp = new PageInfo(list);
        } catch (Exception e) {
            return new PageInfo();
        }
        return pageInfoTmp;
    }

    public boolean online(){
        LambdaQueryWrapper<GoblinFrontNavigation> queryWrapper = Wrappers.lambdaQuery(GoblinFrontNavigation.class);
        queryWrapper.ne(GoblinFrontNavigation::getDelTag,1);
        queryWrapper.orderByDesc(GoblinFrontNavigation::getIndexs);
        List<GoblinFrontNavigation> list=goblinFrontNavigationMapper.selectList(queryWrapper);
        //mongodb
        for(GoblinFrontNavigation goblinFrontNavigation: list){
            GoblinFrontNavigation goblinFrontNavigation1=mongoTemplate.findOne(Query.query(Criteria.where("navigationId").is(goblinFrontNavigation.getNavigationId())), GoblinFrontNavigation.class, GoblinFrontNavigation.class.getSimpleName());
            if(null==goblinFrontNavigation1){
                mongoTemplate.save(goblinFrontNavigation,GoblinFrontNavigation.class.getSimpleName());
            }else{
                BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontNavigation)));
                mongoTemplate.getCollection(GoblinFrontNavigation.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("navigationId").is(goblinFrontNavigation.getNavigationId())).getQueryObject(),
                        orderObject
                );
            }
        }
        //redis
        redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_NAVIGATION,list);
        return true;
    }

}
