package com.liquidnet.service.reconciliation.biz;

import com.liquidnet.service.reconciliation.entity.LrAccountCheckBatch;
import com.liquidnet.service.reconciliation.strategy.parser.IDataParserStrategy;
import com.liquidnet.service.reconciliation.vo.ReconciliationEntityVo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;


/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: 对账文件解析业务逻辑
 * @class: ReconciliationFileParserBiz
 * @Package com.liquidnet.service.reconciliation.biz
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/21 14:20
 */
@Component("reconciliationFileParserBiz")
public class ReconciliationFileParserBiz implements BeanFactoryAware {

	// 加载beanfactory
	private BeanFactory beanFactory;

	public Object getService(String payInterface) {
		return beanFactory.getBean(payInterface);
	}

	public void setBeanFactory(BeanFactory beanFactory) {
		this.beanFactory = beanFactory;
	}

	private static final Log LOG = LogFactory.getLog(ReconciliationFileParserBiz.class);

	/**
	 * 解析file文件
	 * 
	 * @param batch
	 *            对账批次实体
	 * @param file
	 *            下载的对账文件
	 * @param billDate
	 *            下载对账单的日期
	 * 
	 * @param interfaceCode
	 *            具体的支付方式
	 * 
	 * @return 转换之后的vo对象
	 * @throws IOException
	 */
	public List<ReconciliationEntityVo> parser(LrAccountCheckBatch batch, File file, Date billDate, String interfaceCode) throws IOException {

		// 解析成 ReconciliationEntityVo 对象
		List<ReconciliationEntityVo> rcVoList = null;

		// 根据支付方式得到解析器的名字
		String parserClassName = interfaceCode + "Parser";
		LOG.info("根据支付方式得到解析器的名字[" + parserClassName + "]");
		IDataParserStrategy service = null;
		try {
			// 根据名字获取相应的解析器
			service = (IDataParserStrategy) this.getService(parserClassName);
		} catch (NoSuchBeanDefinitionException e) {
			LOG.error("根据解析器的名字[" + parserClassName + "]，没有找到相应的解析器");
			return null;
		}
		// 使用相应的解析器解析文件
		rcVoList = service.parser(file, billDate, batch);

		return rcVoList;

	}
}
