package com.liquidnet.service.kylin.dto.vo.admin;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * <p>
 * 退款手续费说明
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-13
 */
@Data
public class OrderRefundPoundage implements Cloneable {
    @ApiModelProperty(value = "日期 yyyy-MM-dd HH:mm:ss")
    private String day;
    @ApiModelProperty(value = "距离演出开始日期>15天")
    private String content;
    @ApiModelProperty(value = "费率 如果手续费是0.1")
    private BigDecimal present;
    @ApiModelProperty(value = "")
    private int isCanRefund;

    private static final OrderRefundPoundage obj = new OrderRefundPoundage();

    public static OrderRefundPoundage getNew() {
        try {
            return (OrderRefundPoundage) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new OrderRefundPoundage();
        }
    }
}
