package com.liquidnet.service.candy.dto.admin;

import com.liquidnet.commons.lang.constant.LnsRegex;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "CandyMgtCouponBuildParam", description = "新建券入参")
@Data
public class CandyMgtCouponBuildParam {
    //private String couponId;
    //private Integer state;
    @NotBlank(message = "券标题不能为空")
    @ApiModelProperty(required = true, value = "券标题", example = "券标题")
    private String title;
    @ApiModelProperty(required = false, value = "标注", example = "标注")
    private String label;
    @NotBlank(message = "券描述不能为空")
    @ApiModelProperty(required = true, value = "描述：注意/须知", example = "注意/须知")
    private String notice;
    //private Integer exclusive;
    @NotNull(message = "券类别不能为空")
    @ApiModelProperty(required = true, value = "业务类别[0-全场｜1-演出｜2-商品｜3-优先购]", allowableValues = "0,1,2,3")
    private Integer busiType;
    @NotNull(message = "券类型不能为空")
    @ApiModelProperty(required = true, value = "券类型[1-代金券｜2-满减券｜3-兑换券｜4-折扣券｜101-优先券]", allowableValues = "1,2,3,4,101")
    private Integer couType;
    @NotNull(message = "券领取方式不能为空")
    @ApiModelProperty(required = true, value = "领取方式[0-用户输入兑换｜1-发放至用户｜2-积分商品｜3-发送需领取｜4-会员专属]", allowableValues = "0,1,2,3,4")
    private Integer bindType;
    @ApiModelProperty(required = false, value = "折扣[8折即0.8]", example = "0.8")
    private BigDecimal discount;
    @ApiModelProperty(required = false, value = "面值", example = "0.01")
    private BigDecimal valFace;
    @ApiModelProperty(required = false, value = "满减~满", example = "1.00")
    private BigDecimal valOver;
    @ApiModelProperty(required = false, value = "满减~减", example = "0.01")
    private BigDecimal valMinus;
    @ApiModelProperty(required = false, value = "叠加限制[0-限制｜1-叠加]", allowableValues = "0,1")
    @Min(value = 0, message = "叠加限制配置无效")
    @Max(value = 1, message = "叠加限制配置无效")
    private Integer overlay;
    //private Integer overlayLevel;
//    @NotNull(message = "券有效期不能为空")
    @Min(value = 1, message = "有效期不能小于1")
    @ApiModelProperty(required = false, value = "有效期（单位天）", example = "30")
    private Integer validity;
//    @Min(value = 1, message = "兑换有效期不能小于1")
    @ApiModelProperty(required = false, value = "兑换有效期（单位天）", example = "30")
    private Integer redeemValidity;
    //private LocalDateTime redeemStart;
    //private LocalDateTime redeemStop;
    //private LocalDateTime effectAt;
    //private LocalDateTime expireAt;
    //private String operator;
    //private Date createdAt;
    //private Date updatedAt;
    //private String comment;


    @ApiModelProperty(required = true, value = "适用范围列表", dataType = "List", example = "[{\"useScope\": 100,\"busiName\": \"适用名称1\",\"busiId\": \"IDIDIDIDIDIDID1\"},{\"useScope\": 100,\"busiName\": \"适用名称2\",\"busiId\": \"IDIDIDIDIDIDID2\"}]")
    private List<CandyCouponRuleBuildParam> couponRuleList;


    @ApiModelProperty(required = false, value = "发放ID", example = "1")
    private String mcouponId;
//    private String couponId;
    //private Integer state;
    @NotNull(message = "券发放量不能为空")
    @Min(value = 1, message = "发放量不能小于1")
    @ApiModelProperty(required = true, value = "发放量", example = "1")
    private Integer eventAmt;
    @ApiModelProperty(required = false, value = "发放类型[0-保留｜1-会员｜2-手机号｜10-全体用户]", allowableValues = "0,1,2,10")
    private Integer eventType;
    @ApiModelProperty(required = false, value = "`发放类型`为2-手机号时发放手机号以,分隔", example = "18510957291,17701223310")
    private String eventLimit;
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "发放时间格式有误")
    @ApiModelProperty(required = true, value = "发放时间[yyyy-MM-dd HH:mm:ss](立即-当前时间｜预约-点选时间)", example = "2021-08-26 00:00:00")
    private String eventAt;
    @ApiModelProperty(required = false, value = "专享标识[0-常规｜1-会员专属]", allowableValues = "0,1")
    private Integer exclusively;
    //private String operator;
    //private LocalDateTime createdAt;
    //private LocalDateTime updatedAt;
    //private String comment;
}
