package com.liquidnet.service.kylin.dao;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * refund返回给前端的数据字段
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-31 11:19 上午
 */

@Data
public class KylinOrderRefundsEntitiesDao implements Serializable {

    private String title;

    private String enterName;

    private String useStart;

    private Integer isPayment;
    private String isPaymentName;

    private BigDecimal price;

    public void setPaymentName(Integer isPayment){
        this.isPayment=isPayment;
        switch (isPayment){
            case 0:
                this.isPaymentName="未支付";
                break;
            case 1:
                this.isPaymentName="已支付";
                break;
            case 2:
                this.isPaymentName="退款中";
                break;
            case 3:
                this.isPaymentName="已退款";
                break;
            default:
                this.isPaymentName="其他";
                break;
        }
    }

}
