package com.liquidnet.service.slime.dto.vo;

import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketTimesVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "SlimeStationPerformanceVo", description = "演出列表响应参数")
@Data
public class SlimeStationPerformanceVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 2904227908512047961L;
    @ApiModelProperty(position = 10, value = "演出ID[64]")
    private String performancesId;
    @ApiModelProperty(position = 11, value = "类型[101-音乐节,102小型演出(livehouse演出),103巡演]")
    private Integer type;
    @ApiModelProperty(position = 12, value = "演出标题[255]")
    private String title;
    @ApiModelProperty(position = 13, value = "开始时间[yyyy/MM/dd]")
    private String timeStart;
    @ApiModelProperty(position = 14, value = "结束时间[yyyy/MM/dd]")
    private String timeEnd;
    @ApiModelProperty(position = 15, value = "城市名称")
    private String cityName;
    @ApiModelProperty(position = 16, value = "场地名称")
    private String fieldName;
    @ApiModelProperty(position = 17, value = "票种列表信息")
    private List<SlimeStationTicketVo> ticketVoList;
    @ApiModelProperty(position = 18, value = "可下载时间")
    private String canDownTime;
    @ApiModelProperty(position = 20, value = "票房")
    private BigDecimal priceSum;
    @ApiModelProperty(position = 21, value = "票量[9]")
    private Integer number;
    @ApiModelProperty(position = 22, value = "已验票量[9]")
    private Integer checkedNum;
    @ApiModelProperty(position = 23, value = "余量[9]")
    private Integer remainderNum;

    @ApiModelProperty(position = 29, value = "权限（多个权限以.分隔）[4-销售统计|5-验票]")
    private String permissionIds;
    @ApiModelProperty(position = 30, value = "#过程数据，前端无需关注")
    private List<KylinTicketTimesVo> ticketTimeList;

    private static final SlimeStationPerformanceVo obj = new SlimeStationPerformanceVo();

    public static SlimeStationPerformanceVo getNew() {
        try {
            return (SlimeStationPerformanceVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SlimeStationPerformanceVo();
        }
    }
}
