package com.liquidnet.service.sweet.service.impl;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.feign.stone.api.FeignStoneIntegralClient;
import com.liquidnet.service.sweet.entity.SweetWechatUsers;
import com.liquidnet.service.sweet.mapper.SweetWechatUsersMapper;
import com.liquidnet.service.sweet.service.ISweetWechatUsersService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.sweet.utils.WechatUsersRedisUtils;
import com.liquidnet.service.sweet.vo.SweetAppletUsersVo;
import com.liquidnet.service.sweet.vo.SweetWechatUsersVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;

/**
 * <p>
 * 正在现场服务号关注事件储存用户信息表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-05
 */
@Service
@Slf4j
public class SweetWechatUsersServiceImpl extends ServiceImpl<SweetWechatUsersMapper, SweetWechatUsers> implements ISweetWechatUsersService {

    @Autowired
    private FeignStoneIntegralClient feignStoneIntegralClient;

    @Autowired
    private WechatUsersRedisUtils redisUtils;

    @Override
    public ResponseDto doTask(Integer type, String phone, String userId) {
        log.info("SweetDoTask param [type:{}, phone:{},, userId:{}]", type, phone, userId);
        SweetAppletUsersVo sweetAppletUsers = redisUtils.getSweetAppletUsersOfPhone(phone);
        if (null == sweetAppletUsers) {
            return ResponseDto.failure("该账户还未使用过小程序登陆");
        }
        SweetWechatUsersVo sweetWechatUsersSky = redisUtils.getSweetWechatUsersOfUnionId(sweetAppletUsers.getUnionId(), 2);
        if (null != sweetWechatUsersSky) {
            ResponseDto<HashMap<String, Object>> responseDto = feignStoneIntegralClient.doTask(type, userId);
            log.info("SweetDoTask res:{}", responseDto);
            return ResponseDto.success();
        } else {
            return ResponseDto.failure("您还未关注公众号");
        }
    }
}
