package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.commons.lang.constant.LnsRegex;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.GoblinGoodsSpecDto;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtGoodsEditSkuParam", description = "商品管理:编辑商品:编辑/添加SKU入参")
@Data
public class GoblinStoreMgtGoodsEditSkuParam implements Serializable {
    private static final long serialVersionUID = 6657596593310537491L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID[64]")
    @NotBlank(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = true, value = "商品ID[64]")
    @NotNull(message = "商品ID不能为空")
    private String spuId;
    @ApiModelProperty(position = 12, required = false, value = "单品ID[编辑时必传]")
    private String skuId;
    @ApiModelProperty(position = 13, required = true, value = "单品默认图片的url[256]")
    @NotNull(message = "单品默认图片不能为空")
    private String skuPic;
    @ApiModelProperty(position = 14, required = true, value = "单品规格信息")
    @Valid
    @NotNull(message = "规格信息不能为空")
    private List<GoblinGoodsSpecDto> skuSpecList;
    @ApiModelProperty(position = 15, required = false, value = "单品销售价-原价[20,2]")
    private BigDecimal sellPrice;
    @ApiModelProperty(position = 16, required = true, value = "单品现价[20,2]")
    @NotNull(message = "单品现价不能为空")
    @Min(value = 0, message = "单品现价无效")
    private BigDecimal price;
    @ApiModelProperty(position = 17, required = true, value = "单品会员价格[20,2]")
    @NotNull(message = "单品会员价格不能为空")
    @Min(value = 0, message = "单品会员价格无效")
    private BigDecimal priceMember;
    @ApiModelProperty(position = 18, required = false, value = "单品的重量[20,2]")
    private BigDecimal weight;
    @ApiModelProperty(position = 19, required = false, value = "总库存[添加SKU必传]")
    private Integer stock;
    @ApiModelProperty(position = 20, required = false, value = "SKU库存")
    private Integer skuStock;
    @ApiModelProperty(position = 21, required = false, value = "预警库存")
    private Integer warningStock;
    @ApiModelProperty(position = 22, required = true, value = "自定义展示[0-默认展示|1-隐藏不可购买]")
    @NotBlank(message = "是否隐藏不能为空")
    @Pattern(regexp = "\\b(0|1)\\b", message = "购买限制参数无效")
    private String skuAppear;
    @ApiModelProperty(position = 23, required = false, value = "ISBN，针对CD/图书等[100]")
    private String skuIsbn;
    @ApiModelProperty(position = 24, required = true, value = "购买限制[0-全部用户|1-仅会员|2-指定用户]")
    @NotBlank(message = "购买限制不能为空")
    @Pattern(regexp = "\\b(0|1|2)\\b", message = "购买限制参数无效")
    private String buyFactor;
    @ApiModelProperty(position = 25, required = false, value = "购买限制人员名单，购买限制为2-指定用户时必填")
    private String buyRoster;
    @ApiModelProperty(position = 26, required = false, value = "购买限制人员名单操作类型[1-添加|2-删除]，购买限制为2-指定用户时有效")
    @Pattern(regexp = "\\b(1|2)\\b", message = "购买限制人员名单操作类型参数无效")
    private String buyRosterType;
    @ApiModelProperty(position = 27, required = false, value = "限量[0-无限制|X:限购数量]")
    private Integer buyLimit;
    @ApiModelProperty(position = 28, required = false, value = "单品有效期[yyyy-MM-dd HH:mm:ss]")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "单品有效期格式有误")
    private String skuValidity;


    @ApiModelProperty(position = 30, required = false, value = "加减库存")
    private Integer operStock;

    public GoblinGoodsSkuInfoVo initEditGoodsSkuInfoVo(GoblinGoodsSkuInfoVo mgtGoodsSkuInfoVo) {
        GoblinGoodsSkuInfoVo goodsSkuInfoVo = GoblinGoodsSkuInfoVo.getNew();
        List<GoblinGoodsSpecDto> skuSpecList = this.getSkuSpecList();
        if (!CollectionUtils.isEmpty(skuSpecList)) {
            goodsSkuInfoVo.setName("");
            for (GoblinGoodsSpecDto goblinGoodsSpecDto : skuSpecList) {
                goodsSkuInfoVo.setName(goodsSkuInfoVo.getName().concat(goblinGoodsSpecDto.getSpecVname()));
            }
            goodsSkuInfoVo.setSkuSpecList(skuSpecList);
        } else {
            goodsSkuInfoVo.setName(mgtGoodsSkuInfoVo.getName());
            goodsSkuInfoVo.setSkuSpecList(mgtGoodsSkuInfoVo.getSkuSpecList());
        }
        goodsSkuInfoVo.setSkuId(this.getSkuId());
        goodsSkuInfoVo.setSkuPic(this.getSkuPic());
        goodsSkuInfoVo.setSellPrice(null == this.getSellPrice() ? mgtGoodsSkuInfoVo.getSellPrice() : this.getSellPrice());
        goodsSkuInfoVo.setPrice(this.getPrice());
        goodsSkuInfoVo.setPriceMember(this.getPriceMember());
        goodsSkuInfoVo.setWeight(null == this.getWeight() ? mgtGoodsSkuInfoVo.getWeight() : this.getWeight());
        goodsSkuInfoVo.setStock(this.getStock());
        goodsSkuInfoVo.setSkuStock(this.getSkuStock());
        goodsSkuInfoVo.setWarningStock(this.getWarningStock());
        goodsSkuInfoVo.setSkuAppear(this.getSkuAppear());
        goodsSkuInfoVo.setSkuIsbn(null == this.getSkuIsbn() ? mgtGoodsSkuInfoVo.getSkuIsbn() : this.getSkuIsbn());
        goodsSkuInfoVo.setBuyFactor(this.getBuyFactor());
        goodsSkuInfoVo.setBuyRoster(this.getBuyRoster());
        goodsSkuInfoVo.setBuyLimit(this.getBuyLimit());
        goodsSkuInfoVo.setSkuValidity(DateUtil.Formatter.yyyyMMddHHmmss.parse(this.getSkuValidity()));
        return goodsSkuInfoVo;
    }

    public GoblinGoodsSkuInfoVo initEditAddGoodsSkuInfoVo() {
        GoblinGoodsSkuInfoVo vo = GoblinGoodsSkuInfoVo.getNew();
        List<GoblinGoodsSpecDto> skuSpecList = this.getSkuSpecList();
        vo.setName("");
        for (GoblinGoodsSpecDto goblinGoodsSpecDto : skuSpecList) {
            vo.setName(vo.getName().concat(goblinGoodsSpecDto.getSpecVname()));
        }
        vo.setSkuPic(this.getSkuPic());
        vo.setSkuIsbn(this.getSkuIsbn());
        vo.setStock(this.getStock());
        vo.setSkuStock(vo.getStock());
        vo.setSellPrice(this.getSellPrice());
        vo.setPrice(this.getPrice());
        vo.setPriceMember(this.getPriceMember());
        vo.setWeight(this.getWeight());
        vo.setBuyFactor(this.getBuyFactor());
        vo.setBuyRoster(this.getBuyRoster());
        vo.setBuyLimit(this.getBuyLimit());
        vo.setStoreId(this.getStoreId());
        vo.setSkuValidity(DateUtil.Formatter.yyyyMMddHHmmss.parse(this.getSkuValidity()));
        vo.setSkuAppear(this.getSkuAppear());
        vo.setSkuSpecList(skuSpecList);
        return vo;
    }
}
