package com.liquidnet.service.sweet.service.impl.five;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetRichtextFive;
import com.liquidnet.service.sweet.mapper.SweetRichtextFiveMapper;
import com.liquidnet.service.sweet.service.five.ISweetRichtextFiveService;
import com.liquidnet.service.sweet.utils.RedisFiveDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 * 电子宣传手册富文本表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Service
public class SweetRichtextFiveServiceImpl extends ServiceImpl<SweetRichtextFiveMapper, SweetRichtextFive> implements ISweetRichtextFiveService {

    @Autowired
    private SweetRichtextFiveMapper sweetRichtextFiveMapper;
    @Autowired
    private RedisFiveDataUtils redisDataUtils;

    @Override
    public ResponseDto<SweetRichtextFive> get(String manualId, Integer type) {
        try {
            return ResponseDto.success(sweetRichtextFiveMapper.selectOne(Wrappers.lambdaQuery(SweetRichtextFive.class).eq(SweetRichtextFive::getManualId, manualId).eq(SweetRichtextFive::getType, type)));
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String details, String local, String pirUrl, Integer type) {
        try {
            int count = sweetRichtextFiveMapper.selectCount(Wrappers.lambdaQuery(SweetRichtextFive.class).eq(SweetRichtextFive::getManualId, manualId).eq(SweetRichtextFive::getType, type));
            if(count>0){
                return ResponseDto.failure("不能重复添加");
            }
            SweetRichtextFive sweetRichtext = SweetRichtextFive.getNew();
            sweetRichtext.setRichtextId(IDGenerator.nextSnowId());
            sweetRichtext.setManualId(manualId);
            if (type == 5) {
                sweetRichtext.setLocal(local);
                sweetRichtext.setDetails(details);
            } else if (type == 2) {
                sweetRichtext.setPicUrl(pirUrl);
            }else{
                sweetRichtext.setDetails(details);
            }
            sweetRichtext.setType(type);
            sweetRichtext.setCreatedAt(LocalDateTime.now());
            sweetRichtextFiveMapper.insert(sweetRichtext);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> change(String manualId, String details, String local, String pirUrl, Integer type) {
        try {
            SweetRichtextFive sweetRichtext = SweetRichtextFive.getNew();
            sweetRichtext.setRichtextId(IDGenerator.nextSnowId());
            sweetRichtext.setManualId(manualId);
            sweetRichtext.setDetails(details);
            if (type == 5) {
                sweetRichtext.setLocal(local);
            } else if (type == 2) {
                sweetRichtext.setPicUrl(pirUrl);
            }
            sweetRichtext.setType(type);
            sweetRichtext.setCreatedAt(LocalDateTime.now());
            sweetRichtextFiveMapper.update(sweetRichtext, Wrappers.lambdaUpdate(SweetRichtextFive.class).eq(SweetRichtextFive::getManualId, manualId).eq(SweetRichtextFive::getType, type));

            redisDataUtils.setRichTextRedisData(manualId,type.toString(),sweetRichtext);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        return ResponseDto.success();
    }

}
