package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 购物车vo
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinShoppingCartVo implements Serializable {
    @ApiModelProperty(value = "该商铺下的所有商品")
    private List<GoblinShoppingCartVoDetail> list;
    /**
     * 商铺id
     */
    @ApiModelProperty(value = "官方营销表id")
    private String storeId;

    private static final GoblinShoppingCartVo obj = new GoblinShoppingCartVo();
    public static GoblinShoppingCartVo getNew() {
        try {
            return (GoblinShoppingCartVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinShoppingCartVo();
        }
    }


}
