package com.liquidnet.client.admin.zhengzai.smile.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.common.utils.StringUtils;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileAgentService;
import com.liquidnet.service.smile.entity.SmileAgent;
import com.liquidnet.service.smile.mapper.SmileAgentMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-16
 */
@Service
public class SmileAgentServiceImpl extends ServiceImpl<SmileAgentMapper, SmileAgent> implements ISmileAgentService {

    @Autowired
    SmileAgentMapper smileAgentMapper;

    @Override
    public List<SmileAgent> listAgentByShowIdAndTicketId(String performanceId, String ticketId) {
        if (StringUtils.isNotEmpty(performanceId)&&StringUtils.isNotEmpty(ticketId)){
            LambdaQueryWrapper<SmileAgent> queryWrapper = Wrappers.lambdaQuery(SmileAgent.class);
            queryWrapper.eq(true,SmileAgent::getPerformanceId,performanceId);
            queryWrapper.eq(true,SmileAgent::getTicketId,ticketId);
            return smileAgentMapper.selectList(queryWrapper);
        }
        return null;
    }
}
