package com.liquidnet.client.admin.zhengzai.smile.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.smile.dto.UserCheckParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileUserCheckService;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.service.smile.entity.SmileUserCheck;
import com.liquidnet.service.smile.entity.dao.SmileUserCheckDao;
import com.liquidnet.service.smile.mapper.SmileSchoolMapper;
import com.liquidnet.service.smile.mapper.SmileUserCheckMapper;
import com.liquidnet.service.smile.mapper.SmileUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-15
 */
@Service
public class SmileUserCheckServiceImpl extends ServiceImpl<SmileUserCheckMapper, SmileUserCheck> implements ISmileUserCheckService {

    @Autowired
    SmileUserCheckMapper smileUserCheckMapper;

    @Autowired
    SmileUserMapper smileUserMapper;

    @Autowired
    SmileSchoolMapper smileSchoolMapper;

    @Override
    public PageInfo<SmileUserCheckDao> listUserCheck(UserCheckParam userCheckParam) {
        PageInfo<SmileUserCheckDao> pageInfo;
        try {
            Map<String, Object> map = BeanUtil.convertBeanToMap(userCheckParam);
            List<SmileUserCheckDao> smileUserCheckDaos = smileUserMapper.selectUserCheck(map);
            pageInfo = new PageInfo<>(smileUserCheckDaos);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return pageInfo;
    }

    @Override
    public boolean create(SmileUserCheck smileUserCheck) {
        if (smileUserCheck.getUid() != null) {
            //uid=uid   state！=1
            LambdaQueryWrapper<SmileUserCheck> queryWrapper = Wrappers.lambdaQuery(SmileUserCheck.class);
            queryWrapper.eq(SmileUserCheck::getUid, smileUserCheck.getUid());
            queryWrapper.eq(false, SmileUserCheck::getState, 1);
            if (smileUserCheckMapper.selectOne(queryWrapper) == null) {
                smileUserCheck.setCreatedDate(LocalDateTime.now());
                smileUserCheck.setUpdatedDate(LocalDateTime.now());
                smileUserCheck.setState(1);
                smileUserCheck.setDelTag(0);
                return smileUserCheckMapper.insert(smileUserCheck) > 0;
            }
        }
        return false;
    }

    @Override
    public boolean updateUserCheckById(SmileUserCheck smileUserCheck) {
        //state 为1  才可以修改
        LambdaQueryWrapper<SmileUserCheck> queryWrapper = Wrappers.lambdaQuery(SmileUserCheck.class);
        smileUserCheck.setUpdatedDate(LocalDateTime.now());
        return smileUserCheckMapper.update(smileUserCheck, queryWrapper) > 0;
    }


}
