package com.liquidnet.client.admin.web.controller.zhengzai.smile;


import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileSchoolParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileSchoolService;
import com.liquidnet.service.smile.entity.SmileSchool;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-14
 */
@Api(tags = "学校管理")
@RestController
@RequestMapping("/smile/school")
public class SmileSchoolController {

    @Autowired
    ISmileSchoolService iSmileSchoolService;


    @PostMapping("/list")
    @ApiOperation("获取学校列表")
    @ResponseBody
    public AjaxResult schoolList(SmileSchoolParam smileSchoolParam) {
        PageInfo<SmileSchool> smileSchools = iSmileSchoolService.schoolList(smileSchoolParam);
        return AjaxResult.success(smileSchools);
    }

    @GetMapping("/getSchoolById")
    @ApiOperation("根据id获取学校")
    @ResponseBody
    public AjaxResult getSchoolById(@RequestParam(name = "id", required = true)Long id){
        return AjaxResult.success(iSmileSchoolService.getSchoolById(id));
    }

    @PostMapping("/create")
    @ApiOperation("新建学校")
    @ResponseBody
    public AjaxResult create(@RequestBody SmileSchool smileSchool){
        if (iSmileSchoolService.create(smileSchool)){
            return AjaxResult.success();
        }else {
            return AjaxResult.warn("学校已存在");
        }
    }

    @PostMapping("/updateById")
    @ApiOperation("更具id修改学校")
    @ResponseBody
    public AjaxResult updateSchoolById(@RequestBody SmileSchool smileSchool){
        if (iSmileSchoolService.updateSchoolById(smileSchool)) {
            return AjaxResult.success();
        } else {
            return AjaxResult.error();
        }
    }
}
