package com.liquidnet.service.adam.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.AdamUserInfoParam;
import com.liquidnet.service.adam.dto.vo.AdamThirdPartInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.service.IAdamUserInfoService;
import com.liquidnet.service.adam.service.IAdamUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@ApiSupport(order = 10020)
@Api(tags = "用户中心")
@Slf4j
@RestController
@RequestMapping("user")
public class AdamUserController {
    @Autowired
    IAdamUserService adamUserService;
    @Autowired
    IAdamUserInfoService adamUserInfoService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "个人资料编辑")
    @PostMapping(value = {"edit"})
    public ResponseDto<AdamUserInfoVo> edit(@RequestBody AdamUserInfoParam adamUserInfoParam) {
        // TODO: 2021/5/10
        log.info("adamUserInfoParam:{}", JsonUtils.toJson(adamUserInfoParam));
        String uid = "1";

        AdamUserInfoVo userInfoVo = adamUserService.queryByUid(uid);
        BeanUtils.copyProperties(adamUserInfoParam, userInfoVo);

        adamUserInfoService.edit(userInfoVo);

        return ResponseDto.success(userInfoVo);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "手机号修改")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mobile", value = "新手机号"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "code", value = "验证码"),
    })
    @PostMapping(value = {"edit/mobile"})
    public ResponseDto<Object> editMobile(@RequestParam String mobile, @RequestParam String code) {
        log.info("mobile:{},code:{}", mobile, code);

        // TODO: 2021/5/10


        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "密码修改")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mobile", value = "手机号"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "password", value = "密码"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "code", value = "验证码"),
    })
    @PostMapping(value = {"edit/pwd"})
    public ResponseDto<Object> editPwd(@RequestParam String mobile, @RequestParam String password, @RequestParam String code) {
        log.info("mobile:{},password:{},code:{}", mobile, password, code);

        // TODO: 2021/5/10


        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "绑定第三方账号")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "openId", value = "第三方OPENID"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "nickName", value = "昵称"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "avatar", value = "头像"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "platform", value = "平台类型", allowableValues = "WEIBO,WECHAT,QQ"),
    })
    @PostMapping(value = {"tpa/bind"})
    public ResponseDto<List<AdamThirdPartInfoVo>> bindTpa(@RequestParam String openId, @RequestParam String nickname,
                                       @RequestParam String avatar, @RequestParam String platform) {
        log.info("bind tpa openId:{}, nickname:{}, avatar: {}, platform:{}", openId, nickname, avatar, platform);

        // TODO: 2021/5/10
        List<AdamThirdPartInfoVo> voList = new ArrayList<>();
        voList.add(AdamThirdPartInfoVo.getNew());


        return ResponseDto.success(voList);
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "解绑第三方账号")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "platform", value = "平台类型", allowableValues = "WEIBO,WECHAT,QQ"),
    })
    @PostMapping(value = {"tpa/unbind/{platform}"})
    public ResponseDto<List<AdamThirdPartInfoVo>> unbindTpa(@PathVariable String platform) {
        log.info("unbind tpa.platform:{}", platform);

        // TODO: 2021/5/10
        List<AdamThirdPartInfoVo> voList = new ArrayList<>();
        voList.add(AdamThirdPartInfoVo.getNew());


        return ResponseDto.success(voList);
    }
}
