package com.liquidnet.service.kylin.dto.vo;

import com.liquidnet.service.kylin.entity.KylinTicketRelations;
import com.liquidnet.service.kylin.entity.KylinTicketStatus;
import com.liquidnet.service.kylin.entity.KylinTickets;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;

@Data
@ApiModel
public class TicketVo {

    @ApiModelProperty(value = "主键")
    private String ticketsId;
    @ApiModelProperty(value = "场次id")
    private String timeId;
    @ApiModelProperty(value = "名称")
    private String title;
    @ApiModelProperty(value = "类型 1单日 2通票")
    private int type;
    @ApiModelProperty(value = "价格")
    private BigDecimal price;
    @ApiModelProperty(value = "快递费")
    private BigDecimal priceExpress;
    @ApiModelProperty(value = "会员价格")
    private BigDecimal memberPrice;
    @ApiModelProperty(value = "优惠价格")
    private BigDecimal discountPrice;
    @ApiModelProperty(value = "票种描述")
    private String describes;
    @ApiModelProperty(value = "快递票说明")
    private String describeExpress;
    @ApiModelProperty(value = "电子票说明")
    private String describeElectronic;
    @ApiModelProperty(value = "购票开始时间")
    private String timeStart;
    @ApiModelProperty(value = "购票结束时间")
    private String timeEnd;
    @ApiModelProperty(value = "会员购票开始时间")
    private String memberTimeStart;
    @ApiModelProperty(value = "快递票结束时间")
    private String timeEndExpress;
    @ApiModelProperty(value = "适用开始时间")
    private String useStart;
    @ApiModelProperty(value = "适用结束时间")
    private String useEnd;
    @ApiModelProperty(value = "开票倒计时(分钟数)")
    private int saleRemindMinute;
    @ApiModelProperty(value = "是否学生票")
    private int isStudent;
    @ApiModelProperty(value = "是否电子票")
    private int isElectronic;
    @ApiModelProperty(value = "是否快递票")
    private int isExpress;
    @ApiModelProperty(value = "可验证次数")
    private Integer counts;
    @ApiModelProperty(value = "状态")
    private int status;
    @ApiModelProperty(value = "兑换状态")
    private int statusExchange;
    @ApiModelProperty(value = "是否缺票登记")
    private int isLackRegister;
    @ApiModelProperty(value = "快递状态 1寄付 2到付")
    private int expressType;
    @ApiModelProperty(value = "是否实名")
    private int isTrueName;
    @ApiModelProperty(value = "限购张数")
    private int limitCount;
    @ApiModelProperty(value = "会员限购张数")
    private Integer limitCountMember;
    @ApiModelProperty(value = "是否会员专属")
    private int isExclusive;
    @ApiModelProperty(value = "是否会员")
    private int isMember;

    public void setTicket(KylinTickets ticket) {
        this.ticketsId = ticket.getTicketsId();
        this.title = ticket.getTitle();
        this.type = ticket.getType();
        this.price = ticket.getPrice();
        this.priceExpress = ticket.getPriceExpress();
        this.memberPrice = ticket.getPrice().subtract(ticket.getPriceDiscountMember());
        this.discountPrice = ticket.getPrice().subtract(ticket.getPriceDiscount());
        this.describes = ticket.getDescribes();
        this.describeExpress = ticket.getDescribeExpress();
        this.describeElectronic = ticket.getDescribeElectronic();
        this.timeStart = ticket.getTimeStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.timeEnd = ticket.getTimeEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.memberTimeStart = ticket.getTimeStart().plusMinutes(-ticket.getAdvanceMinuteMember()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.timeEndExpress = ticket.getTimeEndExpress().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.useStart = ticket.getUseStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.useEnd = ticket.getUseEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.saleRemindMinute = ticket.getSaleRemindMinute();
    }

    public void setTicketStatus(KylinTicketStatus ticketStatus) {
        this.isMember = ticketStatus.getIsMember();
        this.isExclusive = ticketStatus.getIsExclusive();
        this.isTrueName = ticketStatus.getIsTrueName();
        this.expressType = ticketStatus.getExpressType();
        this.isLackRegister = ticketStatus.getIsLackRegister();
        this.statusExchange = ticketStatus.getStatusExchange();
        this.status = ticketStatus.getStatus();
        this.isElectronic = ticketStatus.getIsElectronic();
        this.isExpress = ticketStatus.getIsExpress();
        this.isStudent = ticketStatus.getIsStudent();
        this.limitCountMember = ticketStatus.getLimitCountMember();
        this.limitCount = ticketStatus.getLimitCount();
        this.counts = ticketStatus.getCounts();
    }

}
