package com.liquidnet.service.kylin.service.admin;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.liquidnet.service.kylin.dao.PerformanceAdminListDao;
import com.liquidnet.service.kylin.dao.PerformanceRecommendAdminDao;
import com.liquidnet.service.kylin.dao.PerformanceTitleDao;
import com.liquidnet.service.kylin.dto.param.PerformanceAdminListParam;
import com.liquidnet.service.kylin.dto.param.PerformanceRecommendAdminParam;
import com.liquidnet.service.kylin.dto.vo.partner.PerformanceMisVo;
import com.liquidnet.service.kylin.entity.KylinPerformances;

import java.util.List;

/**
 * <p>
 * 演出 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
public interface IKylinPerformancesAdminService extends IService<KylinPerformances> {

    /**
     * 获取演出详情
     * @param performancesId 演出id
     * @return PerformanceMisVo
     */
    PerformanceMisVo performanceDetails(String performancesId);

    /**
     * 演出审核
     * @param performancesId 演出id
     * @param status 审核状态 3通过 4拒绝
     * @param rejectTxt 拒绝理由 如果 status == 4 必填
     * @return boolean
     */
    boolean performanceAudit(String performancesId,int status ,String rejectTxt);

    /**
     * 获取 演出列表 (全量)
     * @param performanceAdminListParam 列表搜索参数
     * @return 分页 sql 数据
     */
    PageInfo<PerformanceAdminListDao> getList(PerformanceAdminListParam performanceAdminListParam);

    /**
     * 根据巡演id 查询演出列表 简易
     * @param roadShowId 巡演id
     * @return 20个 sql 数据
     */
    List<PerformanceTitleDao> getListByRoadShowId(String roadShowId);

    /**
     * 根据演出状态 查询演出列表 简易
     * @param status 演出状态
     * @return 20个 sql  数据
     */
    List<PerformanceTitleDao> getListByStatus(String status);

    /**
     * 修改演出的巡演关联
     * @param performancesId 演出id
     * @param roadShowId 巡演id
     * @return boolean
     */
    boolean changeRoadShowId(String performancesId,String roadShowId);

    /**
     * 设置 演出推荐 关联
     * @param performancesId 相关参数
     * @return boolean
     */
    boolean setRecommend(List<PerformanceRecommendAdminParam> performancesId);

    /**
     * 查询 推荐演出列表
     * @return 分页 sql 数据
     */
    PageInfo<PerformanceRecommendAdminDao> listRecommend();

    //获取 演出会员信息(包含场次票)

    //修改 演出会员信息(包含场次票)

    //列表 待审核 演出会员信息

    //详情 待审核 演出会员信息

    //审核 会员信息

    //列表 演出会员审核记录
}
