package com.liquidnet.service.kylin.controller;


import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.PerformanceVo;
import com.liquidnet.service.kylin.service.impl.KylinPerformancesServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 演出 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-11
 */
@Api(tags = "前端-演出")
@RestController
@RequestMapping("performance")
public class KylinPerformancesController {

    @Autowired
    private KylinPerformancesServiceImpl kylinPerformancesService;

    @GetMapping("localList")
    @ApiOperation("本地演出列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "sellTime", value = "开票时间"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "title", value = "演出名称"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "cityId", value = "省份id"),
            @ApiImplicitParam(type = "form", dataType = "Integer", name = "type", value = "演出类型"),
            @ApiImplicitParam(type = "form", dataType = "Integer", name = "page", value = "页码"),
            @ApiImplicitParam(type = "form", dataType = "Integer", name = "size", value = "每页数量"),
            @ApiImplicitParam(type = "form", dataType = "Integer", name = "sortType", value = "1时间正序 2时间倒序"),
    })
    public ResponseDto<HashMap<String, Object>> localList(
            @RequestParam String sellTime, //开票时间
            @RequestParam String title, //演出名称
            @RequestParam String cityId, //省份id
            @RequestParam Integer type, //演出类型
            @RequestParam Integer page,
            @RequestParam Integer size,

            // 排序
            @RequestParam Integer sortType // 1时间正序 2时间倒序
    ) {
        HashMap<String, Object> result = kylinPerformancesService.localList(sellTime, title, cityId, type, page, size, sortType);
        if (result.size() > 0) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取本地演出列表失败");
        }
    }

    @GetMapping("recommendList")
    @ApiOperation("推荐演出列表")
    public ResponseDto<List<PerformanceVo>> recommendList() {
        List<PerformanceVo> result = kylinPerformancesService.recommendList();
        if (result.size() > 0) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取演出列表失败");
        }
    }

    @GetMapping("noticeList")
    @ApiOperation("演出预告列表")
    public ResponseDto<List<PerformanceVo>> noticeList() {
        List<PerformanceVo> result = kylinPerformancesService.noticeList();
        if (result.size() > 0) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取演出列表失败");
        }
    }

    @GetMapping("detail")
    @ApiOperation("演出详情")
    public ResponseDto<HashMap<String, Object>> detail(
            @RequestParam(value = "performancesId") String performancesId //演出id
    ) {
        HashMap<String, Object> result = kylinPerformancesService.detail(performancesId);
        if (result.size() > 0) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取演出列表失败");
        }
    }

}
