package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 首页导航栏

 * </p>
 *
 * @author liquidnet
 * @since 2021-12-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinFrontNavigationVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long mid;

    /**
     * 图片路径或id
     */
    @ApiModelProperty(value = "图片路径或id")
    private String picUrl;

    /**
     * 标题
     */
    @ApiModelProperty( value = "标题")
    private String title;

    /**
     * 商品id
     */
    @ApiModelProperty( value = "商品id")
    private String spuId;

    /**
     * 展示形式：1、一行2、二行
     */
    @ApiModelProperty( value = "展示形式：1、一行2、二行")
    private Integer displayType;

    /**
     * 分类
     */
    @ApiModelProperty( value = "分类")
    private String categoryType;

    /**
     * 活动链接
     */
    @ApiModelProperty( value = "活动链接")
    private String activityUrl;

    /**
     * 1、分类2、专题3、商品单品
     */
    @ApiModelProperty( value = "1、分类2、专题3、商品单品")
    private Integer navigationType;

    /**
     * 顺序
     */
    @ApiModelProperty( value = "顺序")
    private Integer indexs;

    /**
     * 创建时间
     */
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updateTime;

    /**
     * 导航id
     */
    @ApiModelProperty( value = "导航id")
    private String navigationId;

    /**
     * 0未删除1已删除
     */
    @ApiModelProperty( value = "0未删除1已删除")
    private Integer delTag;

    /**
     * 商品名字
     */
    @ApiModelProperty( value = "商品名字")
    private String spuName;
    private static final GoblinFrontNavigationVo obj = new GoblinFrontNavigationVo();

    public static GoblinFrontNavigationVo getNew() {
        try {
            return (GoblinFrontNavigationVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinFrontNavigationVo();
    }

}
