package com.liquidnet.client.admin.zhengzai.kylin.utils;


import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.dto.vo.returns.KylinOrderListVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class OrderUtils {

    @Autowired
    private DataUtils dataUtils;

    public String judgeOrderLimit(
            String userId,
            String idCard,
            String performanceId,
            String ticketId,
            int performanceLimitCount,
            int performanceMemberLimitCount,
            int performanceLimitIdCard,
            int ticketLimitCount,
            int ticketMemberLimitCount,
            int ticketLimitIdCard,
            int memberType,
            int isTrueName
    ) {
        Integer[] integers = orderLimit(userId, idCard, performanceId, ticketId, isTrueName);
        return judgeMemberType(performanceLimitCount, performanceMemberLimitCount, performanceLimitIdCard,
                ticketLimitCount, ticketMemberLimitCount,ticketLimitIdCard,
                memberType, integers[0], integers[1], integers[2], integers[3], isTrueName);
    }

    public Integer[] orderLimit(
            String userId,
            String idCard,
            String performanceId,
            String ticketId,
            int isTrueName
    ) {
        int performanceBuyCountUid = 0;
        int ticketBuyCountUid = 0;
        int performanceBuyCountIdCard = 0;
        int ticketBuyCountIdCard = 0;

        if (1 == isTrueName) {//实名
            performanceBuyCountIdCard = dataUtils.getIdCardPBuyCount(idCard, performanceId);
            ticketBuyCountIdCard = dataUtils.getIdCardTBuyCount(idCard, ticketId);
            performanceBuyCountUid = dataUtils.getUserPBuyCount(userId, performanceId);
            ticketBuyCountUid = dataUtils.getUserTBuyCount(userId, ticketId);
        } else {//非实名
            performanceBuyCountUid = dataUtils.getUserPBuyCount(userId, performanceId);
            ticketBuyCountUid = dataUtils.getUserTBuyCount(userId, ticketId);
        }

        Integer[] array = new Integer[4];
        array[0] = performanceBuyCountUid;
        array[1] = ticketBuyCountUid;
        array[2] = performanceBuyCountIdCard;
        array[3] = ticketBuyCountIdCard;
        return array;
    }

    public String judgeMemberType(int performanceLimitCount, int performanceMemberLimitCount, int performanceLimitIdCard,
                                  int ticketLimitCount, int ticketMemberLimitCount, int ticketLimitIdCard, int memberType,
                                  int performanceBuyCountUid, int ticketBuyCountUid, int performanceBuyCountIdCard, int ticketBuyCountIdCard, int isTrueName) {
        if (memberType == 1 || memberType == 2) {
            if(isTrueName==1){
                if (performanceBuyCountIdCard > performanceMemberLimitCount && performanceMemberLimitCount != 0) {
                    return "实名制演出限购" + performanceMemberLimitCount + "张，已超出";//超过演出维度购买量
                }
                if (ticketBuyCountIdCard > ticketMemberLimitCount && ticketMemberLimitCount != 0) {
                    return "实名制票种限购" + ticketMemberLimitCount + "张，已超出";//超过票维度购买量
                }
            }else{
                if (performanceBuyCountUid > performanceMemberLimitCount && performanceMemberLimitCount != 0) {
                    return "本场演出限购" + performanceMemberLimitCount + "张，已超出";//超过演出维度购买量
                }
                if (ticketBuyCountUid > ticketMemberLimitCount && ticketMemberLimitCount != 0) {
                    return "该票种限购" + ticketMemberLimitCount + "张，已超出";//超过票维度购买量
                }
            }
        } else {//非会员区间
            if(isTrueName==1){
                if (performanceBuyCountUid > performanceLimitCount && performanceLimitCount != 0) {
                    return "本场演出限购" + performanceLimitCount + "张，已超出";//超过演出维度购买量
                }
                if (ticketBuyCountUid > ticketLimitCount && ticketLimitCount != 0) {
                    return "该票种限购" + ticketLimitCount + "张，已超出";//超过演出维度购买量
                }
                if (performanceBuyCountIdCard > performanceLimitIdCard && performanceLimitIdCard != 0) {
                    return "实名制演出限购" + performanceLimitIdCard + "张，已超出";//超过演出维度购买量
                }
                if (ticketBuyCountIdCard > ticketLimitIdCard && ticketLimitIdCard != 0) {
                    return "实名制票种限购" + ticketLimitIdCard + "张，已超出";//超过演出维度购买量
                }
            }else{
                if (performanceBuyCountUid > performanceLimitCount && performanceLimitCount != 0) {
                    return "本场演出限购" + performanceLimitCount + "张，已超出";//超过演出维度购买量
                }
                if (ticketBuyCountUid > ticketLimitCount && ticketLimitCount != 0) {
                    return "该票种限购" + ticketLimitCount + "张，已超出";//超过演出维度购买量
                }
            }
        }
        return "";
    }


    /**
     * @param userId  用户id
     * @param type    1新增 2修改
     * @param orderId 订单id [需要新增或者修改的订单id]
     */
    public Boolean resetOrderListVo(String userId, Integer type, String orderId, KylinOrderTicketVo dataSingle) {
        List<KylinOrderListVo> vo = new ArrayList();
        List<KylinOrderListVo> redisVo = new ArrayList();
        KylinOrderListVo voItem = KylinOrderListVo.getNew();
        KylinOrderTicketVo data;
        if (dataSingle == null) {
            data = dataUtils.getOrderTicketVo(orderId);
        } else {
            data = dataSingle;
        }
        BeanUtils.copyProperties(data, voItem);
        List<KylinOrderListVo> redisData = dataUtils.getOrderList(userId);
        if (type == 1) {
            redisVo.add(voItem);
            if (redisData.size() > 0) {
                if (redisData.get(0).getOrderTicketsId().equals(orderId)) {
                    redisData.remove(0);
                }
            }
        }

        redisVo.addAll(redisData);

        switch (type) {
            case 1:
                for (int i = 0; i < redisVo.size(); i++) {
                    if (i == 40) {
                        break;
                    }
                    if (i == 0) {
                        vo.add(voItem);
                    } else {
                        vo.add(redisVo.get(i));
                    }
                }
                if (redisVo.size() == 0) {
                    vo.add(voItem);
                }
                dataUtils.setOrderList(userId, vo);
                return true;
            case 2:
                for (int i = 0; i < redisVo.size(); i++) {
                    if (i == 40) {
                        break;
                    }
                    if (redisVo.get(i).getOrderTicketsId().equals(orderId)) {
                        vo.add(voItem);
                    } else {
                        vo.add(redisVo.get(i));
                    }
                }
                dataUtils.setOrderList(userId, vo);
                return true;
            default:
                return false;
        }
    }
}
