package com.liquidnet.service.galaxy.service.impl;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishRespDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishResultQueryReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishResultQueryRespDto;
import com.liquidnet.service.galaxy.router.strategy.GalaxyRouterStrategyContext;
import com.liquidnet.service.galaxy.service.IGalaxyPublishService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: NFT发行相关
 * @class: GalaxyPublishServiceImpl
 * @Package com.liquidnet.service.galaxy.service.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 11:28
 */
@Slf4j
@Service("galaxyPublishServiceImpl")
public class GalaxyPublishServiceImpl implements IGalaxyPublishService {
    @Autowired
    private GalaxyRouterStrategyContext galaxyRouterStrategyContext;

    @Override
    public ResponseDto<GalaxyNftPublishRespDto> nftPublish(GalaxyNftPublishReqDto reqDto) {
        return galaxyRouterStrategyContext.getPublishStrategy(reqDto.getRouterType()).nftPublish(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftPublishResultQueryRespDto> nftPublishResultQuery(GalaxyNftPublishResultQueryReqDto reqDto) {
        return galaxyRouterStrategyContext.getPublishStrategy(reqDto.getRouterType()).nftPublishResultQuery(reqDto);
    }
}
