package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityVo;
import com.liquidnet.service.sweet.service.ISweetIntegralActivityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 积分活动表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-25
 */
@Api(tags = "活动-积分抽奖")
@RestController
@RequestMapping("/integralActivity")
public class SweetIntegralActivityController {
    @Autowired
    private ISweetIntegralActivityService activityService;

    @GetMapping("list")
    @ApiOperation("积分抽奖活动列表")
    public ResponseDto<List<IntegralActivityVo>> getList() {
        return activityService.getList();
    }

    @GetMapping("detail/{integralActivityId}")
    @ApiOperation("积分抽奖活动详情")
    public ResponseDto<IntegralActivityVo> detail(@PathVariable("integralActivityId") String integralActivityId) {
        return activityService.detail(integralActivityId);
    }

    @GetMapping("setDrawAllList")
    @ApiOperation("统计最新40条中奖记录")
    public ResponseDto setDrawAllList(@RequestParam String integralActivityId) {
        return activityService.setDrawAllList(integralActivityId);
    }

    @PostMapping("drawBlack")
    @ApiOperation("抽奖黑名单")
    public ResponseDto drawBlack(@RequestParam String uidS) {
        return activityService.drawBlack(uidS);
    }

    @PostMapping("drawWhite")
    @ApiOperation("抽奖白名单")
    public ResponseDto drawWhite(@RequestParam String uidS) {
        return activityService.drawWhite(uidS);
    }
}
