package com.liquidnet.service.candy.dto;

import com.liquidnet.service.candy.entity.CandyCommonCoupon;
import com.liquidnet.service.candy.entity.CandyCoupon;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class CandyCommonCouponBasicDto implements Serializable ,Cloneable{
    private static final long serialVersionUID = 4073256621782131605L;

    /* com.liquidnet.service.candy.entity.CandyCoupon */
    private String couponId;
    //private Integer state;
    private String title;
    private String label;
    private String notice;
    private Integer exclusive;
    private Integer busiType;
    private Integer couType;
    private Integer bindType;
    private BigDecimal discount;
    private BigDecimal valFace;
    private BigDecimal valOver;
    private BigDecimal valMinus;
    private Integer overlay;
    private Integer overlayLevel;
    private Integer validity;
    private Integer redeemValidity;
    private LocalDateTime redeemStart;
    private LocalDateTime redeemStop;
    private LocalDateTime effectAt;
    private LocalDateTime expireAt;
    //private String operator;
    private LocalDateTime createdAt;
    //private Date updatedAt;
    //private String comment;

    /* com.liquidnet.service.candy.entity.CandyCommonCoupon */
    private String ccouponId;
    private String mcouponId;
    //private String couponId;
    private Integer state;
    private Integer ranged;
    //private String comment;

    /* com.liquidnet.service.candy.entity.CandyCouponRule */
    private List<CandyCouponRuleDto> useRules;


    private static final CandyCommonCouponBasicDto obj = new CandyCommonCouponBasicDto();

    public static CandyCommonCouponBasicDto getNew() {
        try {
            return (CandyCommonCouponBasicDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CandyCommonCouponBasicDto();
        }
    }

    public CandyCommonCouponBasicDto copy(CandyCommonCoupon commonCoupon, CandyCoupon coupon, List<CandyCouponRuleDto> couponRuleDtoList) {
        if (null == commonCoupon) return this;
        this.setCouponId(coupon.getCouponId());
        this.setTitle(coupon.getTitle());
        this.setLabel(coupon.getLabel());
        this.setNotice(coupon.getNotice());
        this.setExclusive(coupon.getExclusive());
        this.setBusiType(coupon.getBusiType());
        this.setCouType(coupon.getCouType());
        this.setBindType(coupon.getBindType());
        this.setDiscount(coupon.getDiscount());
        this.setValFace(coupon.getValFace());
        this.setValOver(coupon.getValOver());
        this.setValMinus(coupon.getValMinus());
        this.setOverlay(coupon.getOverlay());
        this.setOverlayLevel(coupon.getOverlayLevel());
        this.setValidity(coupon.getValidity());
        this.setRedeemValidity(coupon.getRedeemValidity());
        this.setRedeemStart(coupon.getRedeemStart());
        this.setRedeemStop(coupon.getRedeemStop());
        this.setEffectAt(coupon.getEffectAt());
        this.setExpireAt(coupon.getExpireAt());
        this.setCreatedAt(coupon.getCreatedAt());

        this.setCcouponId(commonCoupon.getCcouponId());
        this.setMcouponId(commonCoupon.getMcouponId());
        this.setState(commonCoupon.getState());
        this.setRanged(commonCoupon.getRanged());

        this.setUseRules(couponRuleDtoList);
        return this;
    }
}
