package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel(value = "GoblinGoodsInfoVo", description = "商品SPU详情[不包含具体SKU，SKU详情参见'GoblinGoobsSkuInfoVo']")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinGoodsInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -4712015317981742851L;
    @ApiModelProperty(position = 10, value = "店铺ID")
    private String storeId;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 12, value = "商品编码[默认为系统编码，也可手动输入商家自己的编码]")
    private String spuNo;
    @ApiModelProperty(position = 13, value = "商品名称[100]")
    private String name;
    @ApiModelProperty(position = 14, value = "商品副标题[128]")
    private String subtitle;
    @ApiModelProperty(position = 15, value = "销售价[20,2]")
    private BigDecimal sellPrice;
    @ApiModelProperty(position = 16, value = "价格区间MIN[20,2]")
    private BigDecimal priceGe;
    @ApiModelProperty(position = 17, value = "价格区间MAX[20,2]")
    private BigDecimal priceLe;
    @ApiModelProperty(position = 18, value = "商品简介[256]")
    private String intro;
    @ApiModelProperty(position = 19, value = "商品详情", example = "商品详情...")
    private String details;
    @ApiModelProperty(position = 20, value = "封面图片地址[256]")
    private String coverPic;
    @ApiModelProperty(position = 21, value = "商品视频地址")
    private String video;
    @ApiModelProperty(position = 22, value = "规格展现方式[1-常规|2-组合]")
    private String specMode;
    @ApiModelProperty(position = 23, value = "商品一级分类ID[30]")
    private String cateFid;
    @ApiModelProperty(position = 24, value = "商品二级分类ID[30]")
    private String cateSid;
    @ApiModelProperty(position = 25, value = "商品三级分类ID[30]")
    private String cateTid;
    @ApiModelProperty(position = 26, value = "店铺一级分类ID[30]")
    private String storeCateFid;
    @ApiModelProperty(position = 27, value = "店铺二级分类ID[30]")
    private String storeCateSid;
    @ApiModelProperty(position = 28, value = "店铺三级分类ID[31]")
    private String storeCateTid;
    @ApiModelProperty(position = 29, value = "品牌ID[30]")
    private String brandId;

    @ApiModelProperty(position = 30, value = "上架处理方式[1-等待手动上架|2-直接上架售卖|3-预约定时上架]")
    private String shelvesHandle;
    @ApiModelProperty(position = 31, value = "预约上架时间[上架处理方式为3-预约定时上架时需要指定]")
    private String shelvesTime;
    @ApiModelProperty(position = 32, value = "商品有效期[YYYY-MM-DD]")
    private String spuValidity;
    @ApiModelProperty(position = 33, value = "是否虚拟商品[0-否|1-是]")
    private String virtualFlg;
    @ApiModelProperty(position = 34, value = "审核状态[0-编辑中|1-审核中|2-审核不通过|3-审核通过]")
    private String status;
    @ApiModelProperty(position = 35, value = "审核拒绝原因[256]")
    private String reason;
    @ApiModelProperty(position = 36, value = "商品上架状态[0-待上架|1-下架|2-违规|3-上架]")
    private String shelvesStatus;
    @ApiModelProperty(position = 37, value = "自定义展示[0-默认展示|1-隐藏不可购买]")
    private String spuAppear;
    @ApiModelProperty(position = 38, value = "上架时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime shelvesAt;
    @ApiModelProperty(position = 39, value = "商品图片列表")
    private List<String> imageList;
    @ApiModelProperty(position = 40, value = "物流模版")
    private String logisticsTemplate;

    private String createdBy;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    private String updatedBy;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    @ApiModelProperty(position = 51, value = "规格信息")
    private List<GoblinGoodsSpecVo> specVoList;
    @ApiModelProperty(position = 52, value = "商品标签列表")
    private List<GoblinGoodsTagVo> tagVoList;
    @ApiModelProperty(position = 53, value = "商品服务支持列表")
    private List<GoblinServiceSupportVo> serviceSupportVoList;
    @ApiModelProperty(position = 54, value = "音乐人、艺术家、IP列表")
    private List<GoblinGoodsExtagVo> extagVoList;
    @ApiModelProperty(position = 55, value = "活动Id")
    private String marketId;

    @ApiModelProperty(position = 55, value = "SPU包含的SKU_ID列表")
    private List<String> skuIdList;

    private static final GoblinGoodsInfoVo obj = new GoblinGoodsInfoVo();

    public static GoblinGoodsInfoVo getNew() {
        try {
            return (GoblinGoodsInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsInfoVo();
        }
    }
}
