package com.liquidnet.service.goblin.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class SyncOrderParam implements Cloneable {
    @ApiModelProperty(value = "status")
    private Integer status;
    @ApiModelProperty(value = "type")
    private String type;
    @ApiModelProperty(value = "code")
    private String code;
    @ApiModelProperty(value = "paymentId")
    private String paymentId;
    @ApiModelProperty(value = "orderCode")
    private String orderCode;
    @ApiModelProperty(value = "price")
    private BigDecimal price;
    @ApiModelProperty(value = "paymentType")
    private String paymentType;
    @ApiModelProperty(value = "paymentAt")
    private String paymentAt;

    private static final SyncOrderParam obj = new SyncOrderParam();
    public static SyncOrderParam getNew() {
        try {
            return (SyncOrderParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SyncOrderParam();
        }
    }
}
