package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 订单操作日志表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinOrderOperationLog implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 订单操作日志id
     */
    private String orderLogId;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 操作类型[1-确认付款|2-修改金额|3-发货|4-取消订单|5-修改物流单号|6-核销虚拟商品订单]
     */
    private Integer type;

    /**
     * 说明
     */
    private String remark;

    /**
     * 操作人
     */
    private String operationName;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
