package com.liquidnet.service.dragon.channel.wepay.strategy.impl;

import com.liquidnet.service.dragon.channel.wepay.resp.WepayPayRespDto;
import com.liquidnet.service.dragon.channel.wepay.strategy.annotation.StrategyWepayHandler;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.utils.PayWepayUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.SortedMap;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: AlipayStrategyWapImpl
 * @Package com.liquidnet.service.dragon.channel.alipay.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/10 14:34
 */
@Slf4j
@Component
@StrategyWepayHandler(DragonConstant.DeviceFromEnum.APPLET)
public class WepayStrategyAppletImpl extends AbstractWepayStrategy{
    @Value("${liquidnet.dragon.url}")
    private String notifyUrl;

    @Override
    SortedMap<String, Object> appendRequestParam(SortedMap<String, Object> requestMap) {
        requestMap.put("trade_type", "JSAPI");
        requestMap.put("openid", requestMap.get("openId"));
        requestMap.put("appid", PayWepayUtils.getInstance().getAPPLET_APP_ID());
        return requestMap;
    }

    @Override
    DragonPayBaseRespDto buildResponseDto(DragonPayBaseRespDto payBaseRespDto, WepayPayRespDto respDto) {
        payBaseRespDto.getPayData().setMwebUrl(respDto.getMwebUrl());
        return payBaseRespDto;
    }

    @Override
    protected String getRequestUrl() {
        return "https://api.mch.weixin.qq.com/pay/unifiedorder";
    }

    @Override
    protected String getNotifyUrl() {
        return notifyUrl + "/notify/wepay/applet";
    }
}
