package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "KylinStationCheckOrderVo", description = "下载验票-订单响应参数")
@Data
public class KylinStationCheckOrderVo implements Serializable {
    private static final long serialVersionUID = 7450966265904643147L;
    @ApiModelProperty(position = 10, value = "ID[64]")
    private String orderTicketEntitiesId;
    @ApiModelProperty(position = 11, value = "演出ID[64]")
    private String performanceId;
    @ApiModelProperty(position = 12, value = "订单ID")
    private String orderId;
    @ApiModelProperty(position = 13, value = "用户昵称")
    private String enterName;
    @ApiModelProperty(position = 14, value = "用户手机号")
    private String enterMobile;
    @ApiModelProperty(position = 15, value = "出票状态:0-未出票,1-已出票")
    private Integer status;
    @ApiModelProperty(position = 16, value = "支付状态:0-未支付,1-已支付,2-退款中,3-已退款")
    private Integer isPayment;
    @ApiModelProperty(position = 17, value = "出票端:(验票app)android/ios")
    private String checkClient;
    @ApiModelProperty(position = 18, value = "二维身份CODE")
    private String qrCode;

    private static final KylinStationCheckOrderVo obj = new KylinStationCheckOrderVo();

    public static KylinStationCheckOrderVo getNew() {
        try {
            return (KylinStationCheckOrderVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinStationCheckOrderVo();
        }
    }
}
